// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.ServiceFabricManagedClusters.Models;

namespace Azure.ResourceManager.ServiceFabricManagedClusters
{
    public partial class ServiceFabricManagedNodeTypeData : IUtf8JsonSerializable, IJsonModel<ServiceFabricManagedNodeTypeData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServiceFabricManagedNodeTypeData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServiceFabricManagedNodeTypeData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceFabricManagedNodeTypeData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceFabricManagedNodeTypeData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(Sku, options);
            }
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IsPrimary))
            {
                writer.WritePropertyName("isPrimary"u8);
                writer.WriteBooleanValue(IsPrimary.Value);
            }
            if (Optional.IsDefined(VmInstanceCount))
            {
                writer.WritePropertyName("vmInstanceCount"u8);
                writer.WriteNumberValue(VmInstanceCount.Value);
            }
            if (Optional.IsDefined(DataDiskSizeInGB))
            {
                writer.WritePropertyName("dataDiskSizeGB"u8);
                writer.WriteNumberValue(DataDiskSizeInGB.Value);
            }
            if (Optional.IsDefined(DataDiskType))
            {
                writer.WritePropertyName("dataDiskType"u8);
                writer.WriteStringValue(DataDiskType.Value.ToString());
            }
            if (Optional.IsDefined(DataDiskLetter))
            {
                writer.WritePropertyName("dataDiskLetter"u8);
                writer.WriteStringValue(DataDiskLetter);
            }
            if (Optional.IsCollectionDefined(PlacementProperties))
            {
                writer.WritePropertyName("placementProperties"u8);
                writer.WriteStartObject();
                foreach (var item in PlacementProperties)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Capacities))
            {
                writer.WritePropertyName("capacities"u8);
                writer.WriteStartObject();
                foreach (var item in Capacities)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(ApplicationPorts))
            {
                writer.WritePropertyName("applicationPorts"u8);
                writer.WriteObjectValue(ApplicationPorts, options);
            }
            if (Optional.IsDefined(EphemeralPorts))
            {
                writer.WritePropertyName("ephemeralPorts"u8);
                writer.WriteObjectValue(EphemeralPorts, options);
            }
            if (Optional.IsDefined(VmSize))
            {
                writer.WritePropertyName("vmSize"u8);
                writer.WriteStringValue(VmSize);
            }
            if (Optional.IsDefined(VmImagePublisher))
            {
                writer.WritePropertyName("vmImagePublisher"u8);
                writer.WriteStringValue(VmImagePublisher);
            }
            if (Optional.IsDefined(VmImageOffer))
            {
                writer.WritePropertyName("vmImageOffer"u8);
                writer.WriteStringValue(VmImageOffer);
            }
            if (Optional.IsDefined(VmImageSku))
            {
                writer.WritePropertyName("vmImageSku"u8);
                writer.WriteStringValue(VmImageSku);
            }
            if (Optional.IsDefined(VmImageVersion))
            {
                writer.WritePropertyName("vmImageVersion"u8);
                writer.WriteStringValue(VmImageVersion);
            }
            if (Optional.IsCollectionDefined(VmSecrets))
            {
                writer.WritePropertyName("vmSecrets"u8);
                writer.WriteStartArray();
                foreach (var item in VmSecrets)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(VmExtensions))
            {
                writer.WritePropertyName("vmExtensions"u8);
                writer.WriteStartArray();
                foreach (var item in VmExtensions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(VmManagedIdentity))
            {
                writer.WritePropertyName("vmManagedIdentity"u8);
                writer.WriteObjectValue(VmManagedIdentity, options);
            }
            if (Optional.IsDefined(IsStateless))
            {
                writer.WritePropertyName("isStateless"u8);
                writer.WriteBooleanValue(IsStateless.Value);
            }
            if (Optional.IsDefined(HasMultiplePlacementGroups))
            {
                writer.WritePropertyName("multiplePlacementGroups"u8);
                writer.WriteBooleanValue(HasMultiplePlacementGroups.Value);
            }
            if (Optional.IsCollectionDefined(FrontendConfigurations))
            {
                writer.WritePropertyName("frontendConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in FrontendConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(NetworkSecurityRules))
            {
                writer.WritePropertyName("networkSecurityRules"u8);
                writer.WriteStartArray();
                foreach (var item in NetworkSecurityRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AdditionalDataDisks))
            {
                writer.WritePropertyName("additionalDataDisks"u8);
                writer.WriteStartArray();
                foreach (var item in AdditionalDataDisks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsEncryptionAtHostEnabled))
            {
                writer.WritePropertyName("enableEncryptionAtHost"u8);
                writer.WriteBooleanValue(IsEncryptionAtHostEnabled.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(IsAcceleratedNetworkingEnabled))
            {
                writer.WritePropertyName("enableAcceleratedNetworking"u8);
                writer.WriteBooleanValue(IsAcceleratedNetworkingEnabled.Value);
            }
            if (Optional.IsDefined(UseDefaultPublicLoadBalancer))
            {
                writer.WritePropertyName("useDefaultPublicLoadBalancer"u8);
                writer.WriteBooleanValue(UseDefaultPublicLoadBalancer.Value);
            }
            if (Optional.IsDefined(UseTempDataDisk))
            {
                writer.WritePropertyName("useTempDataDisk"u8);
                writer.WriteBooleanValue(UseTempDataDisk.Value);
            }
            if (Optional.IsDefined(IsOverProvisioningEnabled))
            {
                writer.WritePropertyName("enableOverProvisioning"u8);
                writer.WriteBooleanValue(IsOverProvisioningEnabled.Value);
            }
            if (Optional.IsCollectionDefined(Zones))
            {
                writer.WritePropertyName("zones"u8);
                writer.WriteStartArray();
                foreach (var item in Zones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsSpotVm))
            {
                writer.WritePropertyName("isSpotVM"u8);
                writer.WriteBooleanValue(IsSpotVm.Value);
            }
            if (Optional.IsDefined(HostGroupId))
            {
                writer.WritePropertyName("hostGroupId"u8);
                writer.WriteStringValue(HostGroupId);
            }
            if (Optional.IsDefined(UseEphemeralOSDisk))
            {
                writer.WritePropertyName("useEphemeralOSDisk"u8);
                writer.WriteBooleanValue(UseEphemeralOSDisk.Value);
            }
            if (Optional.IsDefined(SpotRestoreTimeout))
            {
                writer.WritePropertyName("spotRestoreTimeout"u8);
                writer.WriteStringValue(SpotRestoreTimeout);
            }
            if (Optional.IsDefined(EvictionPolicy))
            {
                writer.WritePropertyName("evictionPolicy"u8);
                writer.WriteStringValue(EvictionPolicy.Value.ToString());
            }
            if (Optional.IsDefined(VmImageResourceId))
            {
                writer.WritePropertyName("vmImageResourceId"u8);
                writer.WriteStringValue(VmImageResourceId);
            }
            if (Optional.IsDefined(SubnetId))
            {
                writer.WritePropertyName("subnetId"u8);
                writer.WriteStringValue(SubnetId);
            }
            if (Optional.IsCollectionDefined(VmSetupActions))
            {
                writer.WritePropertyName("vmSetupActions"u8);
                writer.WriteStartArray();
                foreach (var item in VmSetupActions)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SecurityType))
            {
                writer.WritePropertyName("securityType"u8);
                writer.WriteStringValue(SecurityType.Value.ToString());
            }
            if (Optional.IsDefined(IsSecureBootEnabled))
            {
                writer.WritePropertyName("secureBootEnabled"u8);
                writer.WriteBooleanValue(IsSecureBootEnabled.Value);
            }
            if (Optional.IsDefined(IsNodePublicIPEnabled))
            {
                writer.WritePropertyName("enableNodePublicIP"u8);
                writer.WriteBooleanValue(IsNodePublicIPEnabled.Value);
            }
            if (Optional.IsDefined(IsNodePublicIPv6Enabled))
            {
                writer.WritePropertyName("enableNodePublicIPv6"u8);
                writer.WriteBooleanValue(IsNodePublicIPv6Enabled.Value);
            }
            if (Optional.IsDefined(VmSharedGalleryImageId))
            {
                writer.WritePropertyName("vmSharedGalleryImageId"u8);
                writer.WriteStringValue(VmSharedGalleryImageId);
            }
            if (Optional.IsDefined(NatGatewayId))
            {
                writer.WritePropertyName("natGatewayId"u8);
                writer.WriteStringValue(NatGatewayId);
            }
            if (Optional.IsCollectionDefined(NatConfigurations))
            {
                writer.WritePropertyName("natConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in NatConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(VmImagePlan))
            {
                writer.WritePropertyName("vmImagePlan"u8);
                writer.WriteObjectValue(VmImagePlan, options);
            }
            if (Optional.IsDefined(ServiceArtifactReferenceId))
            {
                writer.WritePropertyName("serviceArtifactReferenceId"u8);
                writer.WriteStringValue(ServiceArtifactReferenceId);
            }
            if (Optional.IsDefined(DscpConfigurationId))
            {
                writer.WritePropertyName("dscpConfigurationId"u8);
                writer.WriteStringValue(DscpConfigurationId);
            }
            if (Optional.IsCollectionDefined(AdditionalNetworkInterfaceConfigurations))
            {
                writer.WritePropertyName("additionalNetworkInterfaceConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in AdditionalNetworkInterfaceConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ComputerNamePrefix))
            {
                writer.WritePropertyName("computerNamePrefix"u8);
                writer.WriteStringValue(ComputerNamePrefix);
            }
            writer.WriteEndObject();
        }

        ServiceFabricManagedNodeTypeData IJsonModel<ServiceFabricManagedNodeTypeData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceFabricManagedNodeTypeData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceFabricManagedNodeTypeData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServiceFabricManagedNodeTypeData(document.RootElement, options);
        }

        internal static ServiceFabricManagedNodeTypeData DeserializeServiceFabricManagedNodeTypeData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            NodeTypeSku sku = default;
            IDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            bool? isPrimary = default;
            int? vmInstanceCount = default;
            int? dataDiskSizeGB = default;
            ServiceFabricManagedDataDiskType? dataDiskType = default;
            string dataDiskLetter = default;
            IDictionary<string, string> placementProperties = default;
            IDictionary<string, string> capacities = default;
            EndpointRangeDescription applicationPorts = default;
            EndpointRangeDescription ephemeralPorts = default;
            string vmSize = default;
            string vmImagePublisher = default;
            string vmImageOffer = default;
            string vmImageSku = default;
            string vmImageVersion = default;
            IList<NodeTypeVaultSecretGroup> vmSecrets = default;
            IList<NodeTypeVmssExtension> vmExtensions = default;
            VmManagedIdentity vmManagedIdentity = default;
            bool? isStateless = default;
            bool? multiplePlacementGroups = default;
            IList<NodeTypeFrontendConfiguration> frontendConfigurations = default;
            IList<ServiceFabricManagedNetworkSecurityRule> networkSecurityRules = default;
            IList<NodeTypeVmssDataDisk> additionalDataDisks = default;
            bool? enableEncryptionAtHost = default;
            ServiceFabricManagedResourceProvisioningState? provisioningState = default;
            bool? enableAcceleratedNetworking = default;
            bool? useDefaultPublicLoadBalancer = default;
            bool? useTempDataDisk = default;
            bool? enableOverProvisioning = default;
            IList<string> zones = default;
            bool? isSpotVm = default;
            string hostGroupId = default;
            bool? useEphemeralOSDisk = default;
            string spotRestoreTimeout = default;
            SpotNodeVmEvictionPolicyType? evictionPolicy = default;
            ResourceIdentifier vmImageResourceId = default;
            ResourceIdentifier subnetId = default;
            IList<VmSetupAction> vmSetupActions = default;
            ServiceFabricManagedClusterSecurityType? securityType = default;
            bool? secureBootEnabled = default;
            bool? enableNodePublicIP = default;
            bool? enableNodePublicIPv6 = default;
            ResourceIdentifier vmSharedGalleryImageId = default;
            ResourceIdentifier natGatewayId = default;
            IList<NodeTypeNatConfig> natConfigurations = default;
            VmImagePlan vmImagePlan = default;
            ResourceIdentifier serviceArtifactReferenceId = default;
            ResourceIdentifier dscpConfigurationId = default;
            IList<AdditionalNetworkInterfaceConfiguration> additionalNetworkInterfaceConfigurations = default;
            string computerNamePrefix = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sku"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sku = NodeTypeSku.DeserializeNodeTypeSku(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("isPrimary"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isPrimary = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("vmInstanceCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            vmInstanceCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("dataDiskSizeGB"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dataDiskSizeGB = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("dataDiskType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dataDiskType = new ServiceFabricManagedDataDiskType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("dataDiskLetter"u8))
                        {
                            dataDiskLetter = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("placementProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            placementProperties = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("capacities"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            capacities = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("applicationPorts"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            applicationPorts = EndpointRangeDescription.DeserializeEndpointRangeDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("ephemeralPorts"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ephemeralPorts = EndpointRangeDescription.DeserializeEndpointRangeDescription(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("vmSize"u8))
                        {
                            vmSize = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vmImagePublisher"u8))
                        {
                            vmImagePublisher = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vmImageOffer"u8))
                        {
                            vmImageOffer = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vmImageSku"u8))
                        {
                            vmImageSku = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vmImageVersion"u8))
                        {
                            vmImageVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("vmSecrets"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NodeTypeVaultSecretGroup> array = new List<NodeTypeVaultSecretGroup>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NodeTypeVaultSecretGroup.DeserializeNodeTypeVaultSecretGroup(item, options));
                            }
                            vmSecrets = array;
                            continue;
                        }
                        if (property0.NameEquals("vmExtensions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NodeTypeVmssExtension> array = new List<NodeTypeVmssExtension>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NodeTypeVmssExtension.DeserializeNodeTypeVmssExtension(item, options));
                            }
                            vmExtensions = array;
                            continue;
                        }
                        if (property0.NameEquals("vmManagedIdentity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            vmManagedIdentity = VmManagedIdentity.DeserializeVmManagedIdentity(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("isStateless"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isStateless = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("multiplePlacementGroups"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            multiplePlacementGroups = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("frontendConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NodeTypeFrontendConfiguration> array = new List<NodeTypeFrontendConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NodeTypeFrontendConfiguration.DeserializeNodeTypeFrontendConfiguration(item, options));
                            }
                            frontendConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("networkSecurityRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ServiceFabricManagedNetworkSecurityRule> array = new List<ServiceFabricManagedNetworkSecurityRule>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ServiceFabricManagedNetworkSecurityRule.DeserializeServiceFabricManagedNetworkSecurityRule(item, options));
                            }
                            networkSecurityRules = array;
                            continue;
                        }
                        if (property0.NameEquals("additionalDataDisks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NodeTypeVmssDataDisk> array = new List<NodeTypeVmssDataDisk>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NodeTypeVmssDataDisk.DeserializeNodeTypeVmssDataDisk(item, options));
                            }
                            additionalDataDisks = array;
                            continue;
                        }
                        if (property0.NameEquals("enableEncryptionAtHost"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableEncryptionAtHost = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ServiceFabricManagedResourceProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("enableAcceleratedNetworking"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableAcceleratedNetworking = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("useDefaultPublicLoadBalancer"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            useDefaultPublicLoadBalancer = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("useTempDataDisk"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            useTempDataDisk = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableOverProvisioning"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableOverProvisioning = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("zones"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            zones = array;
                            continue;
                        }
                        if (property0.NameEquals("isSpotVM"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isSpotVm = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("hostGroupId"u8))
                        {
                            hostGroupId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("useEphemeralOSDisk"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            useEphemeralOSDisk = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("spotRestoreTimeout"u8))
                        {
                            spotRestoreTimeout = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("evictionPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            evictionPolicy = new SpotNodeVmEvictionPolicyType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("vmImageResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            vmImageResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("subnetId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            subnetId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("vmSetupActions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<VmSetupAction> array = new List<VmSetupAction>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(new VmSetupAction(item.GetString()));
                            }
                            vmSetupActions = array;
                            continue;
                        }
                        if (property0.NameEquals("securityType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            securityType = new ServiceFabricManagedClusterSecurityType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("secureBootEnabled"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            secureBootEnabled = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableNodePublicIP"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableNodePublicIP = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableNodePublicIPv6"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableNodePublicIPv6 = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("vmSharedGalleryImageId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            vmSharedGalleryImageId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("natGatewayId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            natGatewayId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("natConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NodeTypeNatConfig> array = new List<NodeTypeNatConfig>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NodeTypeNatConfig.DeserializeNodeTypeNatConfig(item, options));
                            }
                            natConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("vmImagePlan"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            vmImagePlan = VmImagePlan.DeserializeVmImagePlan(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("serviceArtifactReferenceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            serviceArtifactReferenceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("dscpConfigurationId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            dscpConfigurationId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("additionalNetworkInterfaceConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<AdditionalNetworkInterfaceConfiguration> array = new List<AdditionalNetworkInterfaceConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(AdditionalNetworkInterfaceConfiguration.DeserializeAdditionalNetworkInterfaceConfiguration(item, options));
                            }
                            additionalNetworkInterfaceConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("computerNamePrefix"u8))
                        {
                            computerNamePrefix = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServiceFabricManagedNodeTypeData(
                id,
                name,
                type,
                systemData,
                sku,
                isPrimary,
                vmInstanceCount,
                dataDiskSizeGB,
                dataDiskType,
                dataDiskLetter,
                placementProperties ?? new ChangeTrackingDictionary<string, string>(),
                capacities ?? new ChangeTrackingDictionary<string, string>(),
                applicationPorts,
                ephemeralPorts,
                vmSize,
                vmImagePublisher,
                vmImageOffer,
                vmImageSku,
                vmImageVersion,
                vmSecrets ?? new ChangeTrackingList<NodeTypeVaultSecretGroup>(),
                vmExtensions ?? new ChangeTrackingList<NodeTypeVmssExtension>(),
                vmManagedIdentity,
                isStateless,
                multiplePlacementGroups,
                frontendConfigurations ?? new ChangeTrackingList<NodeTypeFrontendConfiguration>(),
                networkSecurityRules ?? new ChangeTrackingList<ServiceFabricManagedNetworkSecurityRule>(),
                additionalDataDisks ?? new ChangeTrackingList<NodeTypeVmssDataDisk>(),
                enableEncryptionAtHost,
                provisioningState,
                enableAcceleratedNetworking,
                useDefaultPublicLoadBalancer,
                useTempDataDisk,
                enableOverProvisioning,
                zones ?? new ChangeTrackingList<string>(),
                isSpotVm,
                hostGroupId,
                useEphemeralOSDisk,
                spotRestoreTimeout,
                evictionPolicy,
                vmImageResourceId,
                subnetId,
                vmSetupActions ?? new ChangeTrackingList<VmSetupAction>(),
                securityType,
                secureBootEnabled,
                enableNodePublicIP,
                enableNodePublicIPv6,
                vmSharedGalleryImageId,
                natGatewayId,
                natConfigurations ?? new ChangeTrackingList<NodeTypeNatConfig>(),
                vmImagePlan,
                serviceArtifactReferenceId,
                dscpConfigurationId,
                additionalNetworkInterfaceConfigurations ?? new ChangeTrackingList<AdditionalNetworkInterfaceConfiguration>(),
                computerNamePrefix,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServiceFabricManagedNodeTypeData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceFabricManagedNodeTypeData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServiceFabricManagedNodeTypeData)} does not support writing '{options.Format}' format.");
            }
        }

        ServiceFabricManagedNodeTypeData IPersistableModel<ServiceFabricManagedNodeTypeData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceFabricManagedNodeTypeData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServiceFabricManagedNodeTypeData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServiceFabricManagedNodeTypeData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServiceFabricManagedNodeTypeData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
