// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Indicates the update mode for Cross Az clusters. </summary>
    public readonly partial struct ZonalUpdateMode : IEquatable<ZonalUpdateMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ZonalUpdateMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ZonalUpdateMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string FastValue = "Fast";

        /// <summary> The cluster will use 5 upgrade domains for Cross Az Node types. </summary>
        public static ZonalUpdateMode Standard { get; } = new ZonalUpdateMode(StandardValue);
        /// <summary> The cluster will use a maximum of 3 upgrade domains per zone instead of 5 for Cross Az Node types for faster deployments. </summary>
        public static ZonalUpdateMode Fast { get; } = new ZonalUpdateMode(FastValue);
        /// <summary> Determines if two <see cref="ZonalUpdateMode"/> values are the same. </summary>
        public static bool operator ==(ZonalUpdateMode left, ZonalUpdateMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ZonalUpdateMode"/> values are not the same. </summary>
        public static bool operator !=(ZonalUpdateMode left, ZonalUpdateMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ZonalUpdateMode"/>. </summary>
        public static implicit operator ZonalUpdateMode(string value) => new ZonalUpdateMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ZonalUpdateMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ZonalUpdateMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
