// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary>
    /// Vm extension setup order.
    ///
    /// </summary>
    public readonly partial struct VmssExtensionSetupOrder : IEquatable<VmssExtensionSetupOrder>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VmssExtensionSetupOrder"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VmssExtensionSetupOrder(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BeforeSFRuntimeValue = "BeforeSFRuntime";

        /// <summary> Indicates that the vm extension should run before the service fabric runtime starts. </summary>
        public static VmssExtensionSetupOrder BeforeSFRuntime { get; } = new VmssExtensionSetupOrder(BeforeSFRuntimeValue);
        /// <summary> Determines if two <see cref="VmssExtensionSetupOrder"/> values are the same. </summary>
        public static bool operator ==(VmssExtensionSetupOrder left, VmssExtensionSetupOrder right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VmssExtensionSetupOrder"/> values are not the same. </summary>
        public static bool operator !=(VmssExtensionSetupOrder left, VmssExtensionSetupOrder right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VmssExtensionSetupOrder"/>. </summary>
        public static implicit operator VmssExtensionSetupOrder(string value) => new VmssExtensionSetupOrder(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VmssExtensionSetupOrder other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VmssExtensionSetupOrder other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
