// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> action to be performed on the vms before bootstrapping the service fabric runtime. </summary>
    public readonly partial struct VmSetupAction : IEquatable<VmSetupAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VmSetupAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VmSetupAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnableContainersValue = "EnableContainers";
        private const string EnableHyperVValue = "EnableHyperV";

        /// <summary> Enable windows containers feature. </summary>
        public static VmSetupAction EnableContainers { get; } = new VmSetupAction(EnableContainersValue);
        /// <summary> Enables windows HyperV feature. </summary>
        public static VmSetupAction EnableHyperV { get; } = new VmSetupAction(EnableHyperVValue);
        /// <summary> Determines if two <see cref="VmSetupAction"/> values are the same. </summary>
        public static bool operator ==(VmSetupAction left, VmSetupAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VmSetupAction"/> values are not the same. </summary>
        public static bool operator !=(VmSetupAction left, VmSetupAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VmSetupAction"/>. </summary>
        public static implicit operator VmSetupAction(string value) => new VmSetupAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VmSetupAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VmSetupAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
