// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions. </summary>
    public partial class UniformInt64RangePartitionScheme : ManagedServicePartitionScheme
    {
        /// <summary> Initializes a new instance of <see cref="UniformInt64RangePartitionScheme"/>. </summary>
        /// <param name="count"> The number of partitions. </param>
        /// <param name="lowKey">
        /// The lower bound of the partition key range that
        /// should be split between the partition ‘Count’
        ///
        /// </param>
        /// <param name="highKey">
        /// The upper bound of the partition key range that
        /// should be split between the partition ‘Count’
        ///
        /// </param>
        public UniformInt64RangePartitionScheme(int count, long lowKey, long highKey)
        {
            Count = count;
            LowKey = lowKey;
            HighKey = highKey;
            PartitionScheme = PartitionScheme.UniformInt64Range;
        }

        /// <summary> Initializes a new instance of <see cref="UniformInt64RangePartitionScheme"/>. </summary>
        /// <param name="partitionScheme"> Specifies how the service is partitioned. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="count"> The number of partitions. </param>
        /// <param name="lowKey">
        /// The lower bound of the partition key range that
        /// should be split between the partition ‘Count’
        ///
        /// </param>
        /// <param name="highKey">
        /// The upper bound of the partition key range that
        /// should be split between the partition ‘Count’
        ///
        /// </param>
        internal UniformInt64RangePartitionScheme(PartitionScheme partitionScheme, IDictionary<string, BinaryData> serializedAdditionalRawData, int count, long lowKey, long highKey) : base(partitionScheme, serializedAdditionalRawData)
        {
            Count = count;
            LowKey = lowKey;
            HighKey = highKey;
            PartitionScheme = partitionScheme;
        }

        /// <summary> Initializes a new instance of <see cref="UniformInt64RangePartitionScheme"/> for deserialization. </summary>
        internal UniformInt64RangePartitionScheme()
        {
        }

        /// <summary> The number of partitions. </summary>
        public int Count { get; set; }
        /// <summary>
        /// The lower bound of the partition key range that
        /// should be split between the partition ‘Count’
        ///
        /// </summary>
        public long LowKey { get; set; }
        /// <summary>
        /// The upper bound of the partition key range that
        /// should be split between the partition ‘Count’
        ///
        /// </summary>
        public long HighKey { get; set; }
    }
}
