// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Specifies the eviction policy for virtual machines in a SPOT node type. </summary>
    public readonly partial struct SpotNodeVmEvictionPolicyType : IEquatable<SpotNodeVmEvictionPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SpotNodeVmEvictionPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SpotNodeVmEvictionPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DeallocateValue = "Deallocate";

        /// <summary> Eviction policy will be Delete for SPOT vms. </summary>
        public static SpotNodeVmEvictionPolicyType Delete { get; } = new SpotNodeVmEvictionPolicyType(DeleteValue);
        /// <summary> Eviction policy will be Deallocate for SPOT vms. </summary>
        public static SpotNodeVmEvictionPolicyType Deallocate { get; } = new SpotNodeVmEvictionPolicyType(DeallocateValue);
        /// <summary> Determines if two <see cref="SpotNodeVmEvictionPolicyType"/> values are the same. </summary>
        public static bool operator ==(SpotNodeVmEvictionPolicyType left, SpotNodeVmEvictionPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SpotNodeVmEvictionPolicyType"/> values are not the same. </summary>
        public static bool operator !=(SpotNodeVmEvictionPolicyType left, SpotNodeVmEvictionPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SpotNodeVmEvictionPolicyType"/>. </summary>
        public static implicit operator SpotNodeVmEvictionPolicyType(string value) => new SpotNodeVmEvictionPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SpotNodeVmEvictionPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SpotNodeVmEvictionPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
