// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary>
    /// Represents the health policy used to evaluate the health of services belonging to a service type.
    ///
    /// </summary>
    public partial class ServiceTypeHealthPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceTypeHealthPolicy"/>. </summary>
        /// <param name="maxPercentUnhealthyServices">
        /// The maximum allowed percentage of unhealthy services.
        ///
        /// The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
        /// If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
        /// This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
        /// The computation rounds up to tolerate one failure on small numbers of services.
        ///
        /// </param>
        /// <param name="maxPercentUnhealthyPartitionsPerService">
        /// The maximum allowed percentage of unhealthy partitions per service.
        ///
        /// The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
        /// If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
        /// The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
        /// The computation rounds up to tolerate one failure on small numbers of partitions.
        ///
        /// </param>
        /// <param name="maxPercentUnhealthyReplicasPerPartition">
        /// The maximum allowed percentage of unhealthy replicas per partition.
        ///
        /// The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
        /// If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
        /// The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
        /// The computation rounds up to tolerate one failure on small numbers of replicas.
        ///
        /// </param>
        public ServiceTypeHealthPolicy(int maxPercentUnhealthyServices, int maxPercentUnhealthyPartitionsPerService, int maxPercentUnhealthyReplicasPerPartition)
        {
            MaxPercentUnhealthyServices = maxPercentUnhealthyServices;
            MaxPercentUnhealthyPartitionsPerService = maxPercentUnhealthyPartitionsPerService;
            MaxPercentUnhealthyReplicasPerPartition = maxPercentUnhealthyReplicasPerPartition;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceTypeHealthPolicy"/>. </summary>
        /// <param name="maxPercentUnhealthyServices">
        /// The maximum allowed percentage of unhealthy services.
        ///
        /// The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
        /// If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
        /// This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
        /// The computation rounds up to tolerate one failure on small numbers of services.
        ///
        /// </param>
        /// <param name="maxPercentUnhealthyPartitionsPerService">
        /// The maximum allowed percentage of unhealthy partitions per service.
        ///
        /// The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
        /// If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
        /// The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
        /// The computation rounds up to tolerate one failure on small numbers of partitions.
        ///
        /// </param>
        /// <param name="maxPercentUnhealthyReplicasPerPartition">
        /// The maximum allowed percentage of unhealthy replicas per partition.
        ///
        /// The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
        /// If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
        /// The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
        /// The computation rounds up to tolerate one failure on small numbers of replicas.
        ///
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceTypeHealthPolicy(int maxPercentUnhealthyServices, int maxPercentUnhealthyPartitionsPerService, int maxPercentUnhealthyReplicasPerPartition, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaxPercentUnhealthyServices = maxPercentUnhealthyServices;
            MaxPercentUnhealthyPartitionsPerService = maxPercentUnhealthyPartitionsPerService;
            MaxPercentUnhealthyReplicasPerPartition = maxPercentUnhealthyReplicasPerPartition;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceTypeHealthPolicy"/> for deserialization. </summary>
        internal ServiceTypeHealthPolicy()
        {
        }

        /// <summary>
        /// The maximum allowed percentage of unhealthy services.
        ///
        /// The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
        /// If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
        /// This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
        /// The computation rounds up to tolerate one failure on small numbers of services.
        ///
        /// </summary>
        public int MaxPercentUnhealthyServices { get; set; }
        /// <summary>
        /// The maximum allowed percentage of unhealthy partitions per service.
        ///
        /// The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
        /// If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
        /// The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
        /// The computation rounds up to tolerate one failure on small numbers of partitions.
        ///
        /// </summary>
        public int MaxPercentUnhealthyPartitionsPerService { get; set; }
        /// <summary>
        /// The maximum allowed percentage of unhealthy replicas per partition.
        ///
        /// The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
        /// If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
        /// The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
        /// The computation rounds up to tolerate one failure on small numbers of replicas.
        ///
        /// </summary>
        public int MaxPercentUnhealthyReplicasPerPartition { get; set; }
    }
}
