// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Enumerates the ways that a service can be partitioned. </summary>
    internal readonly partial struct ServiceScalingMechanismKind : IEquatable<ServiceScalingMechanismKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceScalingMechanismKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceScalingMechanismKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScalePartitionInstanceCountValue = "ScalePartitionInstanceCount";
        private const string AddRemoveIncrementalNamedPartitionValue = "AddRemoveIncrementalNamedPartition";

        /// <summary> Represents a scaling mechanism for adding or removing instances of stateless service partition. The value is 0. </summary>
        public static ServiceScalingMechanismKind ScalePartitionInstanceCount { get; } = new ServiceScalingMechanismKind(ScalePartitionInstanceCountValue);
        /// <summary> Represents a scaling mechanism for adding or removing named partitions of a stateless service. The value is 1. </summary>
        public static ServiceScalingMechanismKind AddRemoveIncrementalNamedPartition { get; } = new ServiceScalingMechanismKind(AddRemoveIncrementalNamedPartitionValue);
        /// <summary> Determines if two <see cref="ServiceScalingMechanismKind"/> values are the same. </summary>
        public static bool operator ==(ServiceScalingMechanismKind left, ServiceScalingMechanismKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceScalingMechanismKind"/> values are not the same. </summary>
        public static bool operator !=(ServiceScalingMechanismKind left, ServiceScalingMechanismKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceScalingMechanismKind"/>. </summary>
        public static implicit operator ServiceScalingMechanismKind(string value) => new ServiceScalingMechanismKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceScalingMechanismKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceScalingMechanismKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
