// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    public partial class ServicePlacementRequiredDomainPolicy : IUtf8JsonSerializable, IJsonModel<ServicePlacementRequiredDomainPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServicePlacementRequiredDomainPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServicePlacementRequiredDomainPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServicePlacementRequiredDomainPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServicePlacementRequiredDomainPolicy)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("domainName"u8);
            writer.WriteStringValue(DomainName);
        }

        ServicePlacementRequiredDomainPolicy IJsonModel<ServicePlacementRequiredDomainPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServicePlacementRequiredDomainPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServicePlacementRequiredDomainPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServicePlacementRequiredDomainPolicy(document.RootElement, options);
        }

        internal static ServicePlacementRequiredDomainPolicy DeserializeServicePlacementRequiredDomainPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string domainName = default;
            ServicePlacementPolicyType type = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("domainName"u8))
                {
                    domainName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ServicePlacementPolicyType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServicePlacementRequiredDomainPolicy(type, serializedAdditionalRawData, domainName);
        }

        BinaryData IPersistableModel<ServicePlacementRequiredDomainPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServicePlacementRequiredDomainPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServicePlacementRequiredDomainPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        ServicePlacementRequiredDomainPolicy IPersistableModel<ServicePlacementRequiredDomainPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServicePlacementRequiredDomainPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServicePlacementRequiredDomainPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServicePlacementRequiredDomainPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServicePlacementRequiredDomainPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
