// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary>
    /// Describes the policy to be used for placement of a Service Fabric service where two replicas
    /// from the same partition should never be placed in the same fault or upgrade domain.
    ///
    /// While this is not common it can expose the service to an increased risk of concurrent failures
    /// due to unplanned outages or other cases of subsequent/concurrent failures. As an example, consider
    /// a case where replicas are deployed across different data center, with one replica per location.
    /// In the event that one of the datacenters goes offline, normally the replica that was placed in that
    /// datacenter will be packed into one of the remaining datacenters. If this is not desirable then this
    /// policy should be set.
    ///
    /// </summary>
    public partial class ServicePlacementRequireDomainDistributionPolicy : ManagedServicePlacementPolicy
    {
        /// <summary> Initializes a new instance of <see cref="ServicePlacementRequireDomainDistributionPolicy"/>. </summary>
        /// <param name="domainName"> The name of the domain that should used for placement as per this policy. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="domainName"/> is null. </exception>
        public ServicePlacementRequireDomainDistributionPolicy(string domainName)
        {
            Argument.AssertNotNull(domainName, nameof(domainName));

            DomainName = domainName;
            ServicePlacementPolicyType = ServicePlacementPolicyType.RequiredDomainDistribution;
        }

        /// <summary> Initializes a new instance of <see cref="ServicePlacementRequireDomainDistributionPolicy"/>. </summary>
        /// <param name="servicePlacementPolicyType"> The type of placement policy for a service fabric service. Following are the possible values. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="domainName"> The name of the domain that should used for placement as per this policy. </param>
        internal ServicePlacementRequireDomainDistributionPolicy(ServicePlacementPolicyType servicePlacementPolicyType, IDictionary<string, BinaryData> serializedAdditionalRawData, string domainName) : base(servicePlacementPolicyType, serializedAdditionalRawData)
        {
            DomainName = domainName;
            ServicePlacementPolicyType = servicePlacementPolicyType;
        }

        /// <summary> Initializes a new instance of <see cref="ServicePlacementRequireDomainDistributionPolicy"/> for deserialization. </summary>
        internal ServicePlacementRequireDomainDistributionPolicy()
        {
        }

        /// <summary> The name of the domain that should used for placement as per this policy. </summary>
        public string DomainName { get; set; }
    }
}
