// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Describes the policy to be used for placement of a Service Fabric service where a particular fault or upgrade domain should not be used for placement of the instances or replicas of that service. </summary>
    public partial class ServicePlacementInvalidDomainPolicy : ManagedServicePlacementPolicy
    {
        /// <summary> Initializes a new instance of <see cref="ServicePlacementInvalidDomainPolicy"/>. </summary>
        /// <param name="domainName"> The name of the domain that should not be used for placement. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="domainName"/> is null. </exception>
        public ServicePlacementInvalidDomainPolicy(string domainName)
        {
            Argument.AssertNotNull(domainName, nameof(domainName));

            DomainName = domainName;
            ServicePlacementPolicyType = ServicePlacementPolicyType.InvalidDomain;
        }

        /// <summary> Initializes a new instance of <see cref="ServicePlacementInvalidDomainPolicy"/>. </summary>
        /// <param name="servicePlacementPolicyType"> The type of placement policy for a service fabric service. Following are the possible values. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="domainName"> The name of the domain that should not be used for placement. </param>
        internal ServicePlacementInvalidDomainPolicy(ServicePlacementPolicyType servicePlacementPolicyType, IDictionary<string, BinaryData> serializedAdditionalRawData, string domainName) : base(servicePlacementPolicyType, serializedAdditionalRawData)
        {
            DomainName = domainName;
            ServicePlacementPolicyType = servicePlacementPolicyType;
        }

        /// <summary> Initializes a new instance of <see cref="ServicePlacementInvalidDomainPolicy"/> for deserialization. </summary>
        internal ServicePlacementInvalidDomainPolicy()
        {
        }

        /// <summary> The name of the domain that should not be used for placement. </summary>
        public string DomainName { get; set; }
    }
}
