// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> The provisioning state of the managed resource. </summary>
    public readonly partial struct ServiceFabricManagedResourceProvisioningState : IEquatable<ServiceFabricManagedResourceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedResourceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceFabricManagedResourceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string CreatingValue = "Creating";
        private const string CreatedValue = "Created";
        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string OtherValue = "Other";

        /// <summary> None. </summary>
        public static ServiceFabricManagedResourceProvisioningState None { get; } = new ServiceFabricManagedResourceProvisioningState(NoneValue);
        /// <summary> Creating. </summary>
        public static ServiceFabricManagedResourceProvisioningState Creating { get; } = new ServiceFabricManagedResourceProvisioningState(CreatingValue);
        /// <summary> Created. </summary>
        public static ServiceFabricManagedResourceProvisioningState Created { get; } = new ServiceFabricManagedResourceProvisioningState(CreatedValue);
        /// <summary> Updating. </summary>
        public static ServiceFabricManagedResourceProvisioningState Updating { get; } = new ServiceFabricManagedResourceProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static ServiceFabricManagedResourceProvisioningState Succeeded { get; } = new ServiceFabricManagedResourceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ServiceFabricManagedResourceProvisioningState Failed { get; } = new ServiceFabricManagedResourceProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ServiceFabricManagedResourceProvisioningState Canceled { get; } = new ServiceFabricManagedResourceProvisioningState(CanceledValue);
        /// <summary> Deleting. </summary>
        public static ServiceFabricManagedResourceProvisioningState Deleting { get; } = new ServiceFabricManagedResourceProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static ServiceFabricManagedResourceProvisioningState Deleted { get; } = new ServiceFabricManagedResourceProvisioningState(DeletedValue);
        /// <summary> Other. </summary>
        public static ServiceFabricManagedResourceProvisioningState Other { get; } = new ServiceFabricManagedResourceProvisioningState(OtherValue);
        /// <summary> Determines if two <see cref="ServiceFabricManagedResourceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ServiceFabricManagedResourceProvisioningState left, ServiceFabricManagedResourceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceFabricManagedResourceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ServiceFabricManagedResourceProvisioningState left, ServiceFabricManagedResourceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceFabricManagedResourceProvisioningState"/>. </summary>
        public static implicit operator ServiceFabricManagedResourceProvisioningState(string value) => new ServiceFabricManagedResourceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceFabricManagedResourceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceFabricManagedResourceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
