// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Network protocol this rule applies to. </summary>
    public readonly partial struct ServiceFabricManagedNsgProtocol : IEquatable<ServiceFabricManagedNsgProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedNsgProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceFabricManagedNsgProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "http";
        private const string HttpsValue = "https";
        private const string TcpValue = "tcp";
        private const string UdpValue = "udp";
        private const string IcmpValue = "icmp";
        private const string AHValue = "ah";
        private const string EspValue = "esp";

        /// <summary> http. </summary>
        public static ServiceFabricManagedNsgProtocol Http { get; } = new ServiceFabricManagedNsgProtocol(HttpValue);
        /// <summary> https. </summary>
        public static ServiceFabricManagedNsgProtocol Https { get; } = new ServiceFabricManagedNsgProtocol(HttpsValue);
        /// <summary> tcp. </summary>
        public static ServiceFabricManagedNsgProtocol Tcp { get; } = new ServiceFabricManagedNsgProtocol(TcpValue);
        /// <summary> udp. </summary>
        public static ServiceFabricManagedNsgProtocol Udp { get; } = new ServiceFabricManagedNsgProtocol(UdpValue);
        /// <summary> icmp. </summary>
        public static ServiceFabricManagedNsgProtocol Icmp { get; } = new ServiceFabricManagedNsgProtocol(IcmpValue);
        /// <summary> ah. </summary>
        public static ServiceFabricManagedNsgProtocol AH { get; } = new ServiceFabricManagedNsgProtocol(AHValue);
        /// <summary> esp. </summary>
        public static ServiceFabricManagedNsgProtocol Esp { get; } = new ServiceFabricManagedNsgProtocol(EspValue);
        /// <summary> Determines if two <see cref="ServiceFabricManagedNsgProtocol"/> values are the same. </summary>
        public static bool operator ==(ServiceFabricManagedNsgProtocol left, ServiceFabricManagedNsgProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceFabricManagedNsgProtocol"/> values are not the same. </summary>
        public static bool operator !=(ServiceFabricManagedNsgProtocol left, ServiceFabricManagedNsgProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceFabricManagedNsgProtocol"/>. </summary>
        public static implicit operator ServiceFabricManagedNsgProtocol(string value) => new ServiceFabricManagedNsgProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceFabricManagedNsgProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceFabricManagedNsgProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
