// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary>
    /// Managed data disk type. IOPS and throughput are given by the disk size, to see more information go to https://docs.microsoft.com/en-us/azure/virtual-machines/disks-types.
    ///
    /// </summary>
    public readonly partial struct ServiceFabricManagedDataDiskType : IEquatable<ServiceFabricManagedDataDiskType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedDataDiskType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceFabricManagedDataDiskType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardLrsValue = "Standard_LRS";
        private const string StandardSsdLrsValue = "StandardSSD_LRS";
        private const string PremiumLrsValue = "Premium_LRS";

        /// <summary> Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent access. </summary>
        public static ServiceFabricManagedDataDiskType StandardLrs { get; } = new ServiceFabricManagedDataDiskType(StandardLrsValue);
        /// <summary> Standard SSD locally redundant storage. Best for web servers, lightly used enterprise applications and dev/test. </summary>
        public static ServiceFabricManagedDataDiskType StandardSsdLrs { get; } = new ServiceFabricManagedDataDiskType(StandardSsdLrsValue);
        /// <summary> Premium SSD locally redundant storage. Best for production and performance sensitive workloads. </summary>
        public static ServiceFabricManagedDataDiskType PremiumLrs { get; } = new ServiceFabricManagedDataDiskType(PremiumLrsValue);
        /// <summary> Determines if two <see cref="ServiceFabricManagedDataDiskType"/> values are the same. </summary>
        public static bool operator ==(ServiceFabricManagedDataDiskType left, ServiceFabricManagedDataDiskType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceFabricManagedDataDiskType"/> values are not the same. </summary>
        public static bool operator !=(ServiceFabricManagedDataDiskType left, ServiceFabricManagedDataDiskType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceFabricManagedDataDiskType"/>. </summary>
        public static implicit operator ServiceFabricManagedDataDiskType(string value) => new ServiceFabricManagedDataDiskType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceFabricManagedDataDiskType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceFabricManagedDataDiskType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
