// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Sku Name. </summary>
    public readonly partial struct ServiceFabricManagedClustersSkuName : IEquatable<ServiceFabricManagedClustersSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedClustersSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceFabricManagedClustersSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";

        /// <summary> Basic requires a minimum of 3 nodes and allows only 1 node type. </summary>
        public static ServiceFabricManagedClustersSkuName Basic { get; } = new ServiceFabricManagedClustersSkuName(BasicValue);
        /// <summary> Requires a minimum of 5 nodes and allows 1 or more node type. </summary>
        public static ServiceFabricManagedClustersSkuName Standard { get; } = new ServiceFabricManagedClustersSkuName(StandardValue);
        /// <summary> Determines if two <see cref="ServiceFabricManagedClustersSkuName"/> values are the same. </summary>
        public static bool operator ==(ServiceFabricManagedClustersSkuName left, ServiceFabricManagedClustersSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceFabricManagedClustersSkuName"/> values are not the same. </summary>
        public static bool operator !=(ServiceFabricManagedClustersSkuName left, ServiceFabricManagedClustersSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceFabricManagedClustersSkuName"/>. </summary>
        public static implicit operator ServiceFabricManagedClustersSkuName(string value) => new ServiceFabricManagedClustersSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceFabricManagedClustersSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceFabricManagedClustersSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
