// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Specifies the way the operation will be performed. </summary>
    public readonly partial struct ServiceFabricManagedClusterUpdateType : IEquatable<ServiceFabricManagedClusterUpdateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedClusterUpdateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceFabricManagedClusterUpdateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string ByUpgradeDomainValue = "ByUpgradeDomain";

        /// <summary> The operation will proceed in all specified nodes at the same time. </summary>
        public static ServiceFabricManagedClusterUpdateType Default { get; } = new ServiceFabricManagedClusterUpdateType(DefaultValue);
        /// <summary> The operation will proceed one upgrade domain at a time, checking the health in between each to continue. </summary>
        public static ServiceFabricManagedClusterUpdateType ByUpgradeDomain { get; } = new ServiceFabricManagedClusterUpdateType(ByUpgradeDomainValue);
        /// <summary> Determines if two <see cref="ServiceFabricManagedClusterUpdateType"/> values are the same. </summary>
        public static bool operator ==(ServiceFabricManagedClusterUpdateType left, ServiceFabricManagedClusterUpdateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceFabricManagedClusterUpdateType"/> values are not the same. </summary>
        public static bool operator !=(ServiceFabricManagedClusterUpdateType left, ServiceFabricManagedClusterUpdateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceFabricManagedClusterUpdateType"/>. </summary>
        public static implicit operator ServiceFabricManagedClusterUpdateType(string value) => new ServiceFabricManagedClusterUpdateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceFabricManagedClusterUpdateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceFabricManagedClusterUpdateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
