// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> The public IP address configuration of the network interface. </summary>
    public partial class ServiceFabricManagedClusterPublicIPAddressConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedClusterPublicIPAddressConfiguration"/>. </summary>
        /// <param name="name"> Name of the network interface. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public ServiceFabricManagedClusterPublicIPAddressConfiguration(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
            IPTags = new ChangeTrackingList<ManagedClusterIPTag>();
        }

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedClusterPublicIPAddressConfiguration"/>. </summary>
        /// <param name="name"> Name of the network interface. </param>
        /// <param name="ipTags"> Specifies the list of IP tags associated with the public IP address. </param>
        /// <param name="publicIPAddressVersion"> Specifies whether the IP configuration's public IP is IPv4 or IPv6. Default is IPv4. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceFabricManagedClusterPublicIPAddressConfiguration(string name, IList<ManagedClusterIPTag> ipTags, ServiceFabricManagedClusterPublicIPAddressVersion? publicIPAddressVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IPTags = ipTags;
            PublicIPAddressVersion = publicIPAddressVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedClusterPublicIPAddressConfiguration"/> for deserialization. </summary>
        internal ServiceFabricManagedClusterPublicIPAddressConfiguration()
        {
        }

        /// <summary> Name of the network interface. </summary>
        public string Name { get; set; }
        /// <summary> Specifies the list of IP tags associated with the public IP address. </summary>
        public IList<ManagedClusterIPTag> IPTags { get; }
        /// <summary> Specifies whether the IP configuration's public IP is IPv4 or IPv6. Default is IPv4. </summary>
        public ServiceFabricManagedClusterPublicIPAddressVersion? PublicIPAddressVersion { get; set; }
    }
}
