// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Specifies whether the IP configuration's private IP is IPv4 or IPv6. Default is IPv4. </summary>
    public readonly partial struct ServiceFabricManagedClusterPrivateIPAddressVersion : IEquatable<ServiceFabricManagedClusterPrivateIPAddressVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceFabricManagedClusterPrivateIPAddressVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceFabricManagedClusterPrivateIPAddressVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPv4Value = "IPv4";
        private const string IPv6Value = "IPv6";

        /// <summary> IPv4. </summary>
        public static ServiceFabricManagedClusterPrivateIPAddressVersion IPv4 { get; } = new ServiceFabricManagedClusterPrivateIPAddressVersion(IPv4Value);
        /// <summary> IPv6. </summary>
        public static ServiceFabricManagedClusterPrivateIPAddressVersion IPv6 { get; } = new ServiceFabricManagedClusterPrivateIPAddressVersion(IPv6Value);
        /// <summary> Determines if two <see cref="ServiceFabricManagedClusterPrivateIPAddressVersion"/> values are the same. </summary>
        public static bool operator ==(ServiceFabricManagedClusterPrivateIPAddressVersion left, ServiceFabricManagedClusterPrivateIPAddressVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceFabricManagedClusterPrivateIPAddressVersion"/> values are not the same. </summary>
        public static bool operator !=(ServiceFabricManagedClusterPrivateIPAddressVersion left, ServiceFabricManagedClusterPrivateIPAddressVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceFabricManagedClusterPrivateIPAddressVersion"/>. </summary>
        public static implicit operator ServiceFabricManagedClusterPrivateIPAddressVersion(string value) => new ServiceFabricManagedClusterPrivateIPAddressVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceFabricManagedClusterPrivateIPAddressVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceFabricManagedClusterPrivateIPAddressVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
