// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    public partial class RuntimeResumeApplicationUpgradeContent : IUtf8JsonSerializable, IJsonModel<RuntimeResumeApplicationUpgradeContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RuntimeResumeApplicationUpgradeContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RuntimeResumeApplicationUpgradeContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RuntimeResumeApplicationUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RuntimeResumeApplicationUpgradeContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UpgradeDomainName))
            {
                writer.WritePropertyName("upgradeDomainName"u8);
                writer.WriteStringValue(UpgradeDomainName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RuntimeResumeApplicationUpgradeContent IJsonModel<RuntimeResumeApplicationUpgradeContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RuntimeResumeApplicationUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RuntimeResumeApplicationUpgradeContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRuntimeResumeApplicationUpgradeContent(document.RootElement, options);
        }

        internal static RuntimeResumeApplicationUpgradeContent DeserializeRuntimeResumeApplicationUpgradeContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string upgradeDomainName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("upgradeDomainName"u8))
                {
                    upgradeDomainName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RuntimeResumeApplicationUpgradeContent(upgradeDomainName, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RuntimeResumeApplicationUpgradeContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RuntimeResumeApplicationUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RuntimeResumeApplicationUpgradeContent)} does not support writing '{options.Format}' format.");
            }
        }

        RuntimeResumeApplicationUpgradeContent IPersistableModel<RuntimeResumeApplicationUpgradeContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RuntimeResumeApplicationUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRuntimeResumeApplicationUpgradeContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RuntimeResumeApplicationUpgradeContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RuntimeResumeApplicationUpgradeContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
