// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Describes Az Resiliency status of Base resources. </summary>
    public partial class ResourceAzStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceAzStatus"/>. </summary>
        internal ResourceAzStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceAzStatus"/>. </summary>
        /// <param name="resourceName"> VM Size properties. </param>
        /// <param name="resourceType"> VM Size id. </param>
        /// <param name="isZoneResilient"> VM Size name. </param>
        /// <param name="details"> Zone resiliency status details for the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceAzStatus(string resourceName, ResourceType? resourceType, bool? isZoneResilient, string details, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceName = resourceName;
            ResourceType = resourceType;
            IsZoneResilient = isZoneResilient;
            Details = details;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> VM Size properties. </summary>
        public string ResourceName { get; }
        /// <summary> VM Size id. </summary>
        public ResourceType? ResourceType { get; }
        /// <summary> VM Size name. </summary>
        public bool? IsZoneResilient { get; }
        /// <summary> Zone resiliency status details for the resource. </summary>
        public string Details { get; }
    }
}
