// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Managed data disk description. </summary>
    public partial class NodeTypeVmssDataDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NodeTypeVmssDataDisk"/>. </summary>
        /// <param name="lun"> Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is reserved for the service fabric data disk. </param>
        /// <param name="diskSizeInGB"> Disk size for each vm in the node type in GBs. </param>
        /// <param name="diskType"> Managed data disk type. Specifies the storage account type for the managed disk. </param>
        /// <param name="diskLetter"> Managed data disk letter. It can not use the reserved letter C or D and it can not change after created. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="diskLetter"/> is null. </exception>
        public NodeTypeVmssDataDisk(int lun, int diskSizeInGB, ServiceFabricManagedDataDiskType diskType, string diskLetter)
        {
            Argument.AssertNotNull(diskLetter, nameof(diskLetter));

            Lun = lun;
            DiskSizeInGB = diskSizeInGB;
            DiskType = diskType;
            DiskLetter = diskLetter;
        }

        /// <summary> Initializes a new instance of <see cref="NodeTypeVmssDataDisk"/>. </summary>
        /// <param name="lun"> Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is reserved for the service fabric data disk. </param>
        /// <param name="diskSizeInGB"> Disk size for each vm in the node type in GBs. </param>
        /// <param name="diskType"> Managed data disk type. Specifies the storage account type for the managed disk. </param>
        /// <param name="diskLetter"> Managed data disk letter. It can not use the reserved letter C or D and it can not change after created. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NodeTypeVmssDataDisk(int lun, int diskSizeInGB, ServiceFabricManagedDataDiskType diskType, string diskLetter, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Lun = lun;
            DiskSizeInGB = diskSizeInGB;
            DiskType = diskType;
            DiskLetter = diskLetter;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NodeTypeVmssDataDisk"/> for deserialization. </summary>
        internal NodeTypeVmssDataDisk()
        {
        }

        /// <summary> Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is reserved for the service fabric data disk. </summary>
        public int Lun { get; set; }
        /// <summary> Disk size for each vm in the node type in GBs. </summary>
        public int DiskSizeInGB { get; set; }
        /// <summary> Managed data disk type. Specifies the storage account type for the managed disk. </summary>
        public ServiceFabricManagedDataDiskType DiskType { get; set; }
        /// <summary> Managed data disk letter. It can not use the reserved letter C or D and it can not change after created. </summary>
        public string DiskLetter { get; set; }
    }
}
