// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary>
    /// Node type capacity scale type.
    ///
    /// </summary>
    public readonly partial struct NodeTypeSkuScaleType : IEquatable<NodeTypeSkuScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NodeTypeSkuScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NodeTypeSkuScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";

        /// <summary> Node count is not adjustable in any way (e.g. it is fixed). </summary>
        public static NodeTypeSkuScaleType None { get; } = new NodeTypeSkuScaleType(NoneValue);
        /// <summary> The user must manually scale out/in. </summary>
        public static NodeTypeSkuScaleType Manual { get; } = new NodeTypeSkuScaleType(ManualValue);
        /// <summary> Automatic scale is allowed. </summary>
        public static NodeTypeSkuScaleType Automatic { get; } = new NodeTypeSkuScaleType(AutomaticValue);
        /// <summary> Determines if two <see cref="NodeTypeSkuScaleType"/> values are the same. </summary>
        public static bool operator ==(NodeTypeSkuScaleType left, NodeTypeSkuScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NodeTypeSkuScaleType"/> values are not the same. </summary>
        public static bool operator !=(NodeTypeSkuScaleType left, NodeTypeSkuScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NodeTypeSkuScaleType"/>. </summary>
        public static implicit operator NodeTypeSkuScaleType(string value) => new NodeTypeSkuScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NodeTypeSkuScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NodeTypeSkuScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
