// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Describes the named partition scheme of the service. </summary>
    public partial class NamedPartitionScheme : ManagedServicePartitionScheme
    {
        /// <summary> Initializes a new instance of <see cref="NamedPartitionScheme"/>. </summary>
        /// <param name="names"> Array for the names of the partitions. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="names"/> is null. </exception>
        public NamedPartitionScheme(IEnumerable<string> names)
        {
            Argument.AssertNotNull(names, nameof(names));

            Names = names.ToList();
            PartitionScheme = PartitionScheme.Named;
        }

        /// <summary> Initializes a new instance of <see cref="NamedPartitionScheme"/>. </summary>
        /// <param name="partitionScheme"> Specifies how the service is partitioned. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="names"> Array for the names of the partitions. </param>
        internal NamedPartitionScheme(PartitionScheme partitionScheme, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<string> names) : base(partitionScheme, serializedAdditionalRawData)
        {
            Names = names;
            PartitionScheme = partitionScheme;
        }

        /// <summary> Initializes a new instance of <see cref="NamedPartitionScheme"/> for deserialization. </summary>
        internal NamedPartitionScheme()
        {
        }

        /// <summary> Array for the names of the partitions. </summary>
        public IList<string> Names { get; }
    }
}
