// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    public partial class NamedPartitionAddOrRemoveScalingMechanism : IUtf8JsonSerializable, IJsonModel<NamedPartitionAddOrRemoveScalingMechanism>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NamedPartitionAddOrRemoveScalingMechanism>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NamedPartitionAddOrRemoveScalingMechanism>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NamedPartitionAddOrRemoveScalingMechanism>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NamedPartitionAddOrRemoveScalingMechanism)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("minPartitionCount"u8);
            writer.WriteNumberValue(MinPartitionCount);
            writer.WritePropertyName("maxPartitionCount"u8);
            writer.WriteNumberValue(MaxPartitionCount);
            writer.WritePropertyName("scaleIncrement"u8);
            writer.WriteNumberValue(ScaleIncrement);
        }

        NamedPartitionAddOrRemoveScalingMechanism IJsonModel<NamedPartitionAddOrRemoveScalingMechanism>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NamedPartitionAddOrRemoveScalingMechanism>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NamedPartitionAddOrRemoveScalingMechanism)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNamedPartitionAddOrRemoveScalingMechanism(document.RootElement, options);
        }

        internal static NamedPartitionAddOrRemoveScalingMechanism DeserializeNamedPartitionAddOrRemoveScalingMechanism(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int minPartitionCount = default;
            int maxPartitionCount = default;
            int scaleIncrement = default;
            ServiceScalingMechanismKind kind = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("minPartitionCount"u8))
                {
                    minPartitionCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxPartitionCount"u8))
                {
                    maxPartitionCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("scaleIncrement"u8))
                {
                    scaleIncrement = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("kind"u8))
                {
                    kind = new ServiceScalingMechanismKind(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NamedPartitionAddOrRemoveScalingMechanism(kind, serializedAdditionalRawData, minPartitionCount, maxPartitionCount, scaleIncrement);
        }

        BinaryData IPersistableModel<NamedPartitionAddOrRemoveScalingMechanism>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NamedPartitionAddOrRemoveScalingMechanism>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NamedPartitionAddOrRemoveScalingMechanism)} does not support writing '{options.Format}' format.");
            }
        }

        NamedPartitionAddOrRemoveScalingMechanism IPersistableModel<NamedPartitionAddOrRemoveScalingMechanism>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NamedPartitionAddOrRemoveScalingMechanism>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNamedPartitionAddOrRemoveScalingMechanism(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NamedPartitionAddOrRemoveScalingMechanism)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NamedPartitionAddOrRemoveScalingMechanism>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
