// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> The activation Mode of the service package. </summary>
    public readonly partial struct ManagedServicePackageActivationMode : IEquatable<ManagedServicePackageActivationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedServicePackageActivationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedServicePackageActivationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SharedProcessValue = "SharedProcess";
        private const string ExclusiveProcessValue = "ExclusiveProcess";

        /// <summary> Indicates the application package activation mode will use shared process. </summary>
        public static ManagedServicePackageActivationMode SharedProcess { get; } = new ManagedServicePackageActivationMode(SharedProcessValue);
        /// <summary> Indicates the application package activation mode will use exclusive process. </summary>
        public static ManagedServicePackageActivationMode ExclusiveProcess { get; } = new ManagedServicePackageActivationMode(ExclusiveProcessValue);
        /// <summary> Determines if two <see cref="ManagedServicePackageActivationMode"/> values are the same. </summary>
        public static bool operator ==(ManagedServicePackageActivationMode left, ManagedServicePackageActivationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedServicePackageActivationMode"/> values are not the same. </summary>
        public static bool operator !=(ManagedServicePackageActivationMode left, ManagedServicePackageActivationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedServicePackageActivationMode"/>. </summary>
        public static implicit operator ManagedServicePackageActivationMode(string value) => new ManagedServicePackageActivationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedServicePackageActivationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedServicePackageActivationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
