// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Determines the metric weight relative to the other metrics that are configured for this service. During runtime, if two metrics end up in conflict, the Cluster Resource Manager prefers the metric with the higher weight. </summary>
    public readonly partial struct ManagedServiceLoadMetricWeight : IEquatable<ManagedServiceLoadMetricWeight>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedServiceLoadMetricWeight"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedServiceLoadMetricWeight(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ZeroValue = "Zero";
        private const string LowValue = "Low";
        private const string MediumValue = "Medium";
        private const string HighValue = "High";

        /// <summary> Disables resource balancing for this metric. This value is zero. </summary>
        public static ManagedServiceLoadMetricWeight Zero { get; } = new ManagedServiceLoadMetricWeight(ZeroValue);
        /// <summary> Specifies the metric weight of the service load as Low. The value is 1. </summary>
        public static ManagedServiceLoadMetricWeight Low { get; } = new ManagedServiceLoadMetricWeight(LowValue);
        /// <summary> Specifies the metric weight of the service load as Medium. The value is 2. </summary>
        public static ManagedServiceLoadMetricWeight Medium { get; } = new ManagedServiceLoadMetricWeight(MediumValue);
        /// <summary> Specifies the metric weight of the service load as High. The value is 3. </summary>
        public static ManagedServiceLoadMetricWeight High { get; } = new ManagedServiceLoadMetricWeight(HighValue);
        /// <summary> Determines if two <see cref="ManagedServiceLoadMetricWeight"/> values are the same. </summary>
        public static bool operator ==(ManagedServiceLoadMetricWeight left, ManagedServiceLoadMetricWeight right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedServiceLoadMetricWeight"/> values are not the same. </summary>
        public static bool operator !=(ManagedServiceLoadMetricWeight left, ManagedServiceLoadMetricWeight right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedServiceLoadMetricWeight"/>. </summary>
        public static implicit operator ManagedServiceLoadMetricWeight(string value) => new ManagedServiceLoadMetricWeight(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedServiceLoadMetricWeight other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedServiceLoadMetricWeight other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
