// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> The ManagedClusterVersionEnvironment. </summary>
    public readonly partial struct ManagedClusterVersionEnvironment : IEquatable<ManagedClusterVersionEnvironment>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterVersionEnvironment"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterVersionEnvironment(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WindowsValue = "Windows";

        /// <summary> Windows. </summary>
        public static ManagedClusterVersionEnvironment Windows { get; } = new ManagedClusterVersionEnvironment(WindowsValue);
        /// <summary> Determines if two <see cref="ManagedClusterVersionEnvironment"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterVersionEnvironment left, ManagedClusterVersionEnvironment right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterVersionEnvironment"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterVersionEnvironment left, ManagedClusterVersionEnvironment right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterVersionEnvironment"/>. </summary>
        public static implicit operator ManagedClusterVersionEnvironment(string value) => new ManagedClusterVersionEnvironment(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterVersionEnvironment other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterVersionEnvironment other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
