// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary>
    /// The upgrade mode of the cluster when new Service Fabric runtime version is available.
    ///
    /// </summary>
    public readonly partial struct ManagedClusterUpgradeMode : IEquatable<ManagedClusterUpgradeMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterUpgradeMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterUpgradeMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "Automatic";
        private const string ManualValue = "Manual";

        /// <summary> The cluster will be automatically upgraded to the latest Service Fabric runtime version, **clusterUpgradeCadence** will determine when the upgrade starts after the new version becomes available. </summary>
        public static ManagedClusterUpgradeMode Automatic { get; } = new ManagedClusterUpgradeMode(AutomaticValue);
        /// <summary> The cluster will not be automatically upgraded to the latest Service Fabric runtime version. The cluster is upgraded by setting the **clusterCodeVersion** property in the cluster resource. </summary>
        public static ManagedClusterUpgradeMode Manual { get; } = new ManagedClusterUpgradeMode(ManualValue);
        /// <summary> Determines if two <see cref="ManagedClusterUpgradeMode"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterUpgradeMode left, ManagedClusterUpgradeMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterUpgradeMode"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterUpgradeMode left, ManagedClusterUpgradeMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterUpgradeMode"/>. </summary>
        public static implicit operator ManagedClusterUpgradeMode(string value) => new ManagedClusterUpgradeMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterUpgradeMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterUpgradeMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
