// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Enable or Disable apply network policies on private link service in the subnet. </summary>
    public readonly partial struct ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState : IEquatable<ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState Enabled { get; } = new ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState(EnabledValue);
        /// <summary> disabled. </summary>
        public static ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState Disabled { get; } = new ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState(DisabledValue);
        /// <summary> Determines if two <see cref="ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState left, ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState left, ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState"/>. </summary>
        public static implicit operator ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState(string value) => new ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterSubnetPrivateLinkServiceNetworkPoliciesState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
