// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Enable or Disable apply network policies on private end point in the subnet. </summary>
    public readonly partial struct ManagedClusterSubnetPrivateEndpointNetworkPoliciesState : IEquatable<ManagedClusterSubnetPrivateEndpointNetworkPoliciesState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterSubnetPrivateEndpointNetworkPoliciesState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterSubnetPrivateEndpointNetworkPoliciesState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static ManagedClusterSubnetPrivateEndpointNetworkPoliciesState Enabled { get; } = new ManagedClusterSubnetPrivateEndpointNetworkPoliciesState(EnabledValue);
        /// <summary> disabled. </summary>
        public static ManagedClusterSubnetPrivateEndpointNetworkPoliciesState Disabled { get; } = new ManagedClusterSubnetPrivateEndpointNetworkPoliciesState(DisabledValue);
        /// <summary> Determines if two <see cref="ManagedClusterSubnetPrivateEndpointNetworkPoliciesState"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterSubnetPrivateEndpointNetworkPoliciesState left, ManagedClusterSubnetPrivateEndpointNetworkPoliciesState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterSubnetPrivateEndpointNetworkPoliciesState"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterSubnetPrivateEndpointNetworkPoliciesState left, ManagedClusterSubnetPrivateEndpointNetworkPoliciesState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterSubnetPrivateEndpointNetworkPoliciesState"/>. </summary>
        public static implicit operator ManagedClusterSubnetPrivateEndpointNetworkPoliciesState(string value) => new ManagedClusterSubnetPrivateEndpointNetworkPoliciesState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterSubnetPrivateEndpointNetworkPoliciesState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterSubnetPrivateEndpointNetworkPoliciesState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
