// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> The reference to the transport protocol used by the load balancing rule. </summary>
    public readonly partial struct ManagedClusterLoadBalancingRuleTransportProtocol : IEquatable<ManagedClusterLoadBalancingRuleTransportProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterLoadBalancingRuleTransportProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterLoadBalancingRuleTransportProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "tcp";
        private const string UdpValue = "udp";

        /// <summary> tcp. </summary>
        public static ManagedClusterLoadBalancingRuleTransportProtocol Tcp { get; } = new ManagedClusterLoadBalancingRuleTransportProtocol(TcpValue);
        /// <summary> udp. </summary>
        public static ManagedClusterLoadBalancingRuleTransportProtocol Udp { get; } = new ManagedClusterLoadBalancingRuleTransportProtocol(UdpValue);
        /// <summary> Determines if two <see cref="ManagedClusterLoadBalancingRuleTransportProtocol"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterLoadBalancingRuleTransportProtocol left, ManagedClusterLoadBalancingRuleTransportProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterLoadBalancingRuleTransportProtocol"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterLoadBalancingRuleTransportProtocol left, ManagedClusterLoadBalancingRuleTransportProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterLoadBalancingRuleTransportProtocol"/>. </summary>
        public static implicit operator ManagedClusterLoadBalancingRuleTransportProtocol(string value) => new ManagedClusterLoadBalancingRuleTransportProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterLoadBalancingRuleTransportProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterLoadBalancingRuleTransportProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
