// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Describes a load balancing rule. </summary>
    public partial class ManagedClusterLoadBalancingRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterLoadBalancingRule"/>. </summary>
        /// <param name="frontendPort"> The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534. </param>
        /// <param name="backendPort"> The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535. </param>
        /// <param name="protocol"> The reference to the transport protocol used by the load balancing rule. </param>
        /// <param name="probeProtocol"> the reference to the load balancer probe used by the load balancing rule. </param>
        public ManagedClusterLoadBalancingRule(int frontendPort, int backendPort, ManagedClusterLoadBalancingRuleTransportProtocol protocol, ManagedClusterLoadBalanceProbeProtocol probeProtocol)
        {
            FrontendPort = frontendPort;
            BackendPort = backendPort;
            Protocol = protocol;
            ProbeProtocol = probeProtocol;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedClusterLoadBalancingRule"/>. </summary>
        /// <param name="frontendPort"> The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534. </param>
        /// <param name="backendPort"> The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535. </param>
        /// <param name="protocol"> The reference to the transport protocol used by the load balancing rule. </param>
        /// <param name="probePort"> The prob port used by the load balancing rule. Acceptable values are between 1 and 65535. </param>
        /// <param name="probeProtocol"> the reference to the load balancer probe used by the load balancing rule. </param>
        /// <param name="probeRequestPath"> The probe request path. Only supported for HTTP/HTTPS probes. </param>
        /// <param name="loadDistribution"> The load distribution policy for this rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedClusterLoadBalancingRule(int frontendPort, int backendPort, ManagedClusterLoadBalancingRuleTransportProtocol protocol, int? probePort, ManagedClusterLoadBalanceProbeProtocol probeProtocol, string probeRequestPath, string loadDistribution, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FrontendPort = frontendPort;
            BackendPort = backendPort;
            Protocol = protocol;
            ProbePort = probePort;
            ProbeProtocol = probeProtocol;
            ProbeRequestPath = probeRequestPath;
            LoadDistribution = loadDistribution;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedClusterLoadBalancingRule"/> for deserialization. </summary>
        internal ManagedClusterLoadBalancingRule()
        {
        }

        /// <summary> The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 1 and 65534. </summary>
        public int FrontendPort { get; set; }
        /// <summary> The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535. </summary>
        public int BackendPort { get; set; }
        /// <summary> The reference to the transport protocol used by the load balancing rule. </summary>
        public ManagedClusterLoadBalancingRuleTransportProtocol Protocol { get; set; }
        /// <summary> The prob port used by the load balancing rule. Acceptable values are between 1 and 65535. </summary>
        public int? ProbePort { get; set; }
        /// <summary> the reference to the load balancer probe used by the load balancing rule. </summary>
        public ManagedClusterLoadBalanceProbeProtocol ProbeProtocol { get; set; }
        /// <summary> The probe request path. Only supported for HTTP/HTTPS probes. </summary>
        public string ProbeRequestPath { get; set; }
        /// <summary> The load distribution policy for this rule. </summary>
        public string LoadDistribution { get; set; }
    }
}
