// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> the reference to the load balancer probe used by the load balancing rule. </summary>
    public readonly partial struct ManagedClusterLoadBalanceProbeProtocol : IEquatable<ManagedClusterLoadBalanceProbeProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterLoadBalanceProbeProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterLoadBalanceProbeProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "tcp";
        private const string HttpValue = "http";
        private const string HttpsValue = "https";

        /// <summary> tcp. </summary>
        public static ManagedClusterLoadBalanceProbeProtocol Tcp { get; } = new ManagedClusterLoadBalanceProbeProtocol(TcpValue);
        /// <summary> http. </summary>
        public static ManagedClusterLoadBalanceProbeProtocol Http { get; } = new ManagedClusterLoadBalanceProbeProtocol(HttpValue);
        /// <summary> https. </summary>
        public static ManagedClusterLoadBalanceProbeProtocol Https { get; } = new ManagedClusterLoadBalanceProbeProtocol(HttpsValue);
        /// <summary> Determines if two <see cref="ManagedClusterLoadBalanceProbeProtocol"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterLoadBalanceProbeProtocol left, ManagedClusterLoadBalanceProbeProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterLoadBalanceProbeProtocol"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterLoadBalanceProbeProtocol left, ManagedClusterLoadBalanceProbeProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterLoadBalanceProbeProtocol"/>. </summary>
        public static implicit operator ManagedClusterLoadBalanceProbeProtocol(string value) => new ManagedClusterLoadBalanceProbeProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterLoadBalanceProbeProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterLoadBalanceProbeProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
