// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabricManagedClusters.Models
{
    /// <summary> Port range details. </summary>
    public partial class EndpointRangeDescription
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EndpointRangeDescription"/>. </summary>
        /// <param name="startPort"> Starting port of a range of ports. </param>
        /// <param name="endPort"> End port of a range of ports. </param>
        public EndpointRangeDescription(int startPort, int endPort)
        {
            StartPort = startPort;
            EndPort = endPort;
        }

        /// <summary> Initializes a new instance of <see cref="EndpointRangeDescription"/>. </summary>
        /// <param name="startPort"> Starting port of a range of ports. </param>
        /// <param name="endPort"> End port of a range of ports. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EndpointRangeDescription(int startPort, int endPort, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartPort = startPort;
            EndPort = endPort;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EndpointRangeDescription"/> for deserialization. </summary>
        internal EndpointRangeDescription()
        {
        }

        /// <summary> Starting port of a range of ports. </summary>
        public int StartPort { get; set; }
        /// <summary> End port of a range of ports. </summary>
        public int EndPort { get; set; }
    }
}
