// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabricManagedClusters
{
    internal class ServiceFabricManagedClusterOperationSource : IOperationSource<ServiceFabricManagedClusterResource>
    {
        private readonly ArmClient _client;

        internal ServiceFabricManagedClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceFabricManagedClusterResource IOperationSource<ServiceFabricManagedClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServiceFabricManagedClusterData.DeserializeServiceFabricManagedClusterData(document.RootElement);
            return new ServiceFabricManagedClusterResource(_client, data);
        }

        async ValueTask<ServiceFabricManagedClusterResource> IOperationSource<ServiceFabricManagedClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServiceFabricManagedClusterData.DeserializeServiceFabricManagedClusterData(document.RootElement);
            return new ServiceFabricManagedClusterResource(_client, data);
        }
    }
}
