// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ServiceFabric
{
    /// <summary>
    /// A class representing a collection of <see cref="ServiceFabricVmSizeResource"/> and their operations.
    /// Each <see cref="ServiceFabricVmSizeResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get a <see cref="ServiceFabricVmSizeResourceCollection"/> instance call the GetServiceFabricVmSizeResources method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class ServiceFabricVmSizeResourceCollection : ArmCollection, IEnumerable<ServiceFabricVmSizeResource>, IAsyncEnumerable<ServiceFabricVmSizeResource>
    {
        private readonly ClientDiagnostics _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics;
        private readonly UnsupportedVmSizesRestOperations _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient;
        private readonly AzureLocation _location;

        /// <summary> Initializes a new instance of the <see cref="ServiceFabricVmSizeResourceCollection"/> class for mocking. </summary>
        protected ServiceFabricVmSizeResourceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServiceFabricVmSizeResourceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="location"> The location parameter. </param>
        internal ServiceFabricVmSizeResourceCollection(ArmClient client, ResourceIdentifier id, AzureLocation location) : base(client, id)
        {
            _location = location;
            _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ServiceFabric", ServiceFabricVmSizeResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServiceFabricVmSizeResource.ResourceType, out string serviceFabricVmSizeResourceUnsupportedVmSizesApiVersion);
            _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient = new UnsupportedVmSizesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serviceFabricVmSizeResourceUnsupportedVmSizesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get unsupported vm size for Service Fabric Clusters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes/{vmSize}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmSize"> VM Size name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmSize"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmSize"/> is null. </exception>
        public virtual async Task<Response<ServiceFabricVmSizeResource>> GetAsync(string vmSize, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmSize, nameof(vmSize));

            using var scope = _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics.CreateScope("ServiceFabricVmSizeResourceCollection.Get");
            scope.Start();
            try
            {
                var response = await _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), vmSize, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceFabricVmSizeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get unsupported vm size for Service Fabric Clusters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes/{vmSize}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmSize"> VM Size name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmSize"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmSize"/> is null. </exception>
        public virtual Response<ServiceFabricVmSizeResource> Get(string vmSize, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmSize, nameof(vmSize));

            using var scope = _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics.CreateScope("ServiceFabricVmSizeResourceCollection.Get");
            scope.Start();
            try
            {
                var response = _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), vmSize, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServiceFabricVmSizeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the lists of unsupported vm sizes for Service Fabric Clusters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServiceFabricVmSizeResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServiceFabricVmSizeResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.CreateListRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ServiceFabricVmSizeResource(Client, ServiceFabricVmSizeResourceData.DeserializeServiceFabricVmSizeResourceData(e)), _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics, Pipeline, "ServiceFabricVmSizeResourceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get the lists of unsupported vm sizes for Service Fabric Clusters.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServiceFabricVmSizeResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServiceFabricVmSizeResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.CreateListRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ServiceFabricVmSizeResource(Client, ServiceFabricVmSizeResourceData.DeserializeServiceFabricVmSizeResourceData(e)), _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics, Pipeline, "ServiceFabricVmSizeResourceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes/{vmSize}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmSize"> VM Size name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmSize"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmSize"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string vmSize, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmSize, nameof(vmSize));

            using var scope = _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics.CreateScope("ServiceFabricVmSizeResourceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), vmSize, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes/{vmSize}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmSize"> VM Size name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmSize"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmSize"/> is null. </exception>
        public virtual Response<bool> Exists(string vmSize, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmSize, nameof(vmSize));

            using var scope = _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics.CreateScope("ServiceFabricVmSizeResourceCollection.Exists");
            scope.Start();
            try
            {
                var response = _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), vmSize, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes/{vmSize}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmSize"> VM Size name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmSize"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmSize"/> is null. </exception>
        public virtual async Task<NullableResponse<ServiceFabricVmSizeResource>> GetIfExistsAsync(string vmSize, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmSize, nameof(vmSize));

            using var scope = _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics.CreateScope("ServiceFabricVmSizeResourceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), vmSize, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServiceFabricVmSizeResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceFabricVmSizeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.ServiceFabric/locations/{location}/unsupportedVmSizes/{vmSize}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>UnsupportedVmSizes_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServiceFabricVmSizeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vmSize"> VM Size name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="vmSize"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="vmSize"/> is null. </exception>
        public virtual NullableResponse<ServiceFabricVmSizeResource> GetIfExists(string vmSize, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(vmSize, nameof(vmSize));

            using var scope = _serviceFabricVmSizeResourceUnsupportedVmSizesClientDiagnostics.CreateScope("ServiceFabricVmSizeResourceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serviceFabricVmSizeResourceUnsupportedVmSizesRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), vmSize, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServiceFabricVmSizeResource>(response.GetRawResponse());
                return Response.FromValue(new ServiceFabricVmSizeResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServiceFabricVmSizeResource> IEnumerable<ServiceFabricVmSizeResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServiceFabricVmSizeResource> IAsyncEnumerable<ServiceFabricVmSizeResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
