// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    public partial class ServiceLoadMetricDescription : IUtf8JsonSerializable, IJsonModel<ServiceLoadMetricDescription>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServiceLoadMetricDescription>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServiceLoadMetricDescription>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceLoadMetricDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceLoadMetricDescription)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            if (Optional.IsDefined(Weight))
            {
                writer.WritePropertyName("weight"u8);
                writer.WriteStringValue(Weight.Value.ToString());
            }
            if (Optional.IsDefined(PrimaryDefaultLoad))
            {
                writer.WritePropertyName("primaryDefaultLoad"u8);
                writer.WriteNumberValue(PrimaryDefaultLoad.Value);
            }
            if (Optional.IsDefined(SecondaryDefaultLoad))
            {
                writer.WritePropertyName("secondaryDefaultLoad"u8);
                writer.WriteNumberValue(SecondaryDefaultLoad.Value);
            }
            if (Optional.IsDefined(DefaultLoad))
            {
                writer.WritePropertyName("defaultLoad"u8);
                writer.WriteNumberValue(DefaultLoad.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServiceLoadMetricDescription IJsonModel<ServiceLoadMetricDescription>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceLoadMetricDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServiceLoadMetricDescription)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServiceLoadMetricDescription(document.RootElement, options);
        }

        internal static ServiceLoadMetricDescription DeserializeServiceLoadMetricDescription(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            ServiceLoadMetricWeight? weight = default;
            int? primaryDefaultLoad = default;
            int? secondaryDefaultLoad = default;
            int? defaultLoad = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("weight"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    weight = new ServiceLoadMetricWeight(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("primaryDefaultLoad"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primaryDefaultLoad = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("secondaryDefaultLoad"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secondaryDefaultLoad = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("defaultLoad"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    defaultLoad = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServiceLoadMetricDescription(
                name,
                weight,
                primaryDefaultLoad,
                secondaryDefaultLoad,
                defaultLoad,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServiceLoadMetricDescription>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceLoadMetricDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServiceLoadMetricDescription)} does not support writing '{options.Format}' format.");
            }
        }

        ServiceLoadMetricDescription IPersistableModel<ServiceLoadMetricDescription>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServiceLoadMetricDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServiceLoadMetricDescription(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServiceLoadMetricDescription)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServiceLoadMetricDescription>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
