// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> The detail of the Service Fabric runtime version result. </summary>
    public partial class ClusterVersionDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterVersionDetails"/>. </summary>
        internal ClusterVersionDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterVersionDetails"/>. </summary>
        /// <param name="codeVersion"> The Service Fabric runtime version of the cluster. </param>
        /// <param name="supportExpireOn"> The date of expiry of support of the version. </param>
        /// <param name="environment"> Indicates if this version is for Windows or Linux operating system. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterVersionDetails(string codeVersion, DateTimeOffset? supportExpireOn, ClusterEnvironment? environment, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CodeVersion = codeVersion;
            SupportExpireOn = supportExpireOn;
            Environment = environment;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Service Fabric runtime version of the cluster. </summary>
        public string CodeVersion { get; }
        /// <summary> The date of expiry of support of the version. </summary>
        public DateTimeOffset? SupportExpireOn { get; }
        /// <summary> Indicates if this version is for Windows or Linux operating system. </summary>
        public ClusterEnvironment? Environment { get; }
    }
}
