// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> Describes a list of server certificates referenced by common name that are used to secure the cluster. </summary>
    public partial class ClusterServerCertificateCommonNames
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterServerCertificateCommonNames"/>. </summary>
        public ClusterServerCertificateCommonNames()
        {
            CommonNames = new ChangeTrackingList<ClusterServerCertificateCommonName>();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterServerCertificateCommonNames"/>. </summary>
        /// <param name="commonNames"> The list of server certificates referenced by common name that are used to secure the cluster. </param>
        /// <param name="x509StoreName"> The local certificate store location. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterServerCertificateCommonNames(IList<ClusterServerCertificateCommonName> commonNames, ClusterCertificateStoreName? x509StoreName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CommonNames = commonNames;
            X509StoreName = x509StoreName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of server certificates referenced by common name that are used to secure the cluster. </summary>
        public IList<ClusterServerCertificateCommonName> CommonNames { get; }
        /// <summary> The local certificate store location. </summary>
        public ClusterCertificateStoreName? X509StoreName { get; set; }
    }
}
