// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary>
    /// The reliability level sets the replica set size of system services. Learn about [ReliabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
    ///
    ///   - None - Run the System services with a target replica set count of 1. This should only be used for test clusters.
    ///   - Bronze - Run the System services with a target replica set count of 3. This should only be used for test clusters.
    ///   - Silver - Run the System services with a target replica set count of 5.
    ///   - Gold - Run the System services with a target replica set count of 7.
    ///   - Platinum - Run the System services with a target replica set count of 9.
    ///
    /// </summary>
    public readonly partial struct ClusterReliabilityLevel : IEquatable<ClusterReliabilityLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterReliabilityLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterReliabilityLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string BronzeValue = "Bronze";
        private const string SilverValue = "Silver";
        private const string GoldValue = "Gold";
        private const string PlatinumValue = "Platinum";

        /// <summary> None. </summary>
        public static ClusterReliabilityLevel None { get; } = new ClusterReliabilityLevel(NoneValue);
        /// <summary> Bronze. </summary>
        public static ClusterReliabilityLevel Bronze { get; } = new ClusterReliabilityLevel(BronzeValue);
        /// <summary> Silver. </summary>
        public static ClusterReliabilityLevel Silver { get; } = new ClusterReliabilityLevel(SilverValue);
        /// <summary> Gold. </summary>
        public static ClusterReliabilityLevel Gold { get; } = new ClusterReliabilityLevel(GoldValue);
        /// <summary> Platinum. </summary>
        public static ClusterReliabilityLevel Platinum { get; } = new ClusterReliabilityLevel(PlatinumValue);
        /// <summary> Determines if two <see cref="ClusterReliabilityLevel"/> values are the same. </summary>
        public static bool operator ==(ClusterReliabilityLevel left, ClusterReliabilityLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterReliabilityLevel"/> values are not the same. </summary>
        public static bool operator !=(ClusterReliabilityLevel left, ClusterReliabilityLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterReliabilityLevel"/>. </summary>
        public static implicit operator ClusterReliabilityLevel(string value) => new ClusterReliabilityLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterReliabilityLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterReliabilityLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
