// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> The notification channel indicates the type of receivers subscribed to the notification, either user or subscription. </summary>
    public readonly partial struct ClusterNotificationChannel : IEquatable<ClusterNotificationChannel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterNotificationChannel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterNotificationChannel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EmailUserValue = "EmailUser";
        private const string EmailSubscriptionValue = "EmailSubscription";

        /// <summary> For email user receivers. In this case, the parameter receivers should be a list of email addresses that will receive the notifications. </summary>
        public static ClusterNotificationChannel EmailUser { get; } = new ClusterNotificationChannel(EmailUserValue);
        /// <summary> For subscription receivers. In this case, the parameter receivers should be a list of roles of the subscription for the cluster (eg. Owner, AccountAdmin, etc) that will receive the notifications. </summary>
        public static ClusterNotificationChannel EmailSubscription { get; } = new ClusterNotificationChannel(EmailSubscriptionValue);
        /// <summary> Determines if two <see cref="ClusterNotificationChannel"/> values are the same. </summary>
        public static bool operator ==(ClusterNotificationChannel left, ClusterNotificationChannel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterNotificationChannel"/> values are not the same. </summary>
        public static bool operator !=(ClusterNotificationChannel left, ClusterNotificationChannel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterNotificationChannel"/>. </summary>
        public static implicit operator ClusterNotificationChannel(string value) => new ClusterNotificationChannel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterNotificationChannel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterNotificationChannel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
