// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> The category of notification. </summary>
    public readonly partial struct ClusterNotificationCategory : IEquatable<ClusterNotificationCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterNotificationCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterNotificationCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WaveProgressValue = "WaveProgress";

        /// <summary> Notification will be regarding wave progress. </summary>
        public static ClusterNotificationCategory WaveProgress { get; } = new ClusterNotificationCategory(WaveProgressValue);
        /// <summary> Determines if two <see cref="ClusterNotificationCategory"/> values are the same. </summary>
        public static bool operator ==(ClusterNotificationCategory left, ClusterNotificationCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterNotificationCategory"/> values are not the same. </summary>
        public static bool operator !=(ClusterNotificationCategory left, ClusterNotificationCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterNotificationCategory"/>. </summary>
        public static implicit operator ClusterNotificationCategory(string value) => new ClusterNotificationCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterNotificationCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterNotificationCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
