// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> Describes the notification channel for cluster events. </summary>
    public partial class ClusterNotification
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterNotification"/>. </summary>
        /// <param name="isEnabled"> Indicates if the notification is enabled. </param>
        /// <param name="notificationCategory"> The category of notification. </param>
        /// <param name="notificationLevel"> The level of notification. </param>
        /// <param name="notificationTargets"> List of targets that subscribe to the notification. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="notificationTargets"/> is null. </exception>
        public ClusterNotification(bool isEnabled, ClusterNotificationCategory notificationCategory, ClusterNotificationLevel notificationLevel, IEnumerable<ClusterNotificationTarget> notificationTargets)
        {
            Argument.AssertNotNull(notificationTargets, nameof(notificationTargets));

            IsEnabled = isEnabled;
            NotificationCategory = notificationCategory;
            NotificationLevel = notificationLevel;
            NotificationTargets = notificationTargets.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ClusterNotification"/>. </summary>
        /// <param name="isEnabled"> Indicates if the notification is enabled. </param>
        /// <param name="notificationCategory"> The category of notification. </param>
        /// <param name="notificationLevel"> The level of notification. </param>
        /// <param name="notificationTargets"> List of targets that subscribe to the notification. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterNotification(bool isEnabled, ClusterNotificationCategory notificationCategory, ClusterNotificationLevel notificationLevel, IList<ClusterNotificationTarget> notificationTargets, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            NotificationCategory = notificationCategory;
            NotificationLevel = notificationLevel;
            NotificationTargets = notificationTargets;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClusterNotification"/> for deserialization. </summary>
        internal ClusterNotification()
        {
        }

        /// <summary> Indicates if the notification is enabled. </summary>
        public bool IsEnabled { get; set; }
        /// <summary> The category of notification. </summary>
        public ClusterNotificationCategory NotificationCategory { get; set; }
        /// <summary> The level of notification. </summary>
        public ClusterNotificationLevel NotificationLevel { get; set; }
        /// <summary> List of targets that subscribe to the notification. </summary>
        public IList<ClusterNotificationTarget> NotificationTargets { get; }
    }
}
