// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    public partial class ClusterNotification : IUtf8JsonSerializable, IJsonModel<ClusterNotification>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClusterNotification>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClusterNotification>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNotification>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterNotification)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("isEnabled"u8);
            writer.WriteBooleanValue(IsEnabled);
            writer.WritePropertyName("notificationCategory"u8);
            writer.WriteStringValue(NotificationCategory.ToString());
            writer.WritePropertyName("notificationLevel"u8);
            writer.WriteStringValue(NotificationLevel.ToString());
            writer.WritePropertyName("notificationTargets"u8);
            writer.WriteStartArray();
            foreach (var item in NotificationTargets)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClusterNotification IJsonModel<ClusterNotification>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNotification>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterNotification)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClusterNotification(document.RootElement, options);
        }

        internal static ClusterNotification DeserializeClusterNotification(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool isEnabled = default;
            ClusterNotificationCategory notificationCategory = default;
            ClusterNotificationLevel notificationLevel = default;
            IList<ClusterNotificationTarget> notificationTargets = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isEnabled"u8))
                {
                    isEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("notificationCategory"u8))
                {
                    notificationCategory = new ClusterNotificationCategory(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("notificationLevel"u8))
                {
                    notificationLevel = new ClusterNotificationLevel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("notificationTargets"u8))
                {
                    List<ClusterNotificationTarget> array = new List<ClusterNotificationTarget>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ClusterNotificationTarget.DeserializeClusterNotificationTarget(item, options));
                    }
                    notificationTargets = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClusterNotification(isEnabled, notificationCategory, notificationLevel, notificationTargets, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ClusterNotification>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNotification>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ClusterNotification)} does not support writing '{options.Format}' format.");
            }
        }

        ClusterNotification IPersistableModel<ClusterNotification>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNotification>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClusterNotification(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClusterNotification)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClusterNotification>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
