// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    public partial class ClusterNodeTypeDescription : IUtf8JsonSerializable, IJsonModel<ClusterNodeTypeDescription>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClusterNodeTypeDescription>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClusterNodeTypeDescription>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNodeTypeDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterNodeTypeDescription)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            if (Optional.IsCollectionDefined(PlacementProperties))
            {
                writer.WritePropertyName("placementProperties"u8);
                writer.WriteStartObject();
                foreach (var item in PlacementProperties)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Capacities))
            {
                writer.WritePropertyName("capacities"u8);
                writer.WriteStartObject();
                foreach (var item in Capacities)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("clientConnectionEndpointPort"u8);
            writer.WriteNumberValue(ClientConnectionEndpointPort);
            writer.WritePropertyName("httpGatewayEndpointPort"u8);
            writer.WriteNumberValue(HttpGatewayEndpointPort);
            if (Optional.IsDefined(DurabilityLevel))
            {
                writer.WritePropertyName("durabilityLevel"u8);
                writer.WriteStringValue(DurabilityLevel.Value.ToString());
            }
            if (Optional.IsDefined(ApplicationPorts))
            {
                writer.WritePropertyName("applicationPorts"u8);
                writer.WriteObjectValue(ApplicationPorts, options);
            }
            if (Optional.IsDefined(EphemeralPorts))
            {
                writer.WritePropertyName("ephemeralPorts"u8);
                writer.WriteObjectValue(EphemeralPorts, options);
            }
            writer.WritePropertyName("isPrimary"u8);
            writer.WriteBooleanValue(IsPrimary);
            writer.WritePropertyName("vmInstanceCount"u8);
            writer.WriteNumberValue(VmInstanceCount);
            if (Optional.IsDefined(ReverseProxyEndpointPort))
            {
                writer.WritePropertyName("reverseProxyEndpointPort"u8);
                writer.WriteNumberValue(ReverseProxyEndpointPort.Value);
            }
            if (Optional.IsDefined(IsStateless))
            {
                writer.WritePropertyName("isStateless"u8);
                writer.WriteBooleanValue(IsStateless.Value);
            }
            if (Optional.IsDefined(IsMultipleAvailabilityZonesSupported))
            {
                writer.WritePropertyName("multipleAvailabilityZones"u8);
                writer.WriteBooleanValue(IsMultipleAvailabilityZonesSupported.Value);
            }
            if (Optional.IsDefined(HttpGatewayTokenAuthEndpointPort))
            {
                writer.WritePropertyName("httpGatewayTokenAuthEndpointPort"u8);
                writer.WriteNumberValue(HttpGatewayTokenAuthEndpointPort.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClusterNodeTypeDescription IJsonModel<ClusterNodeTypeDescription>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNodeTypeDescription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClusterNodeTypeDescription)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClusterNodeTypeDescription(document.RootElement, options);
        }

        internal static ClusterNodeTypeDescription DeserializeClusterNodeTypeDescription(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            IDictionary<string, string> placementProperties = default;
            IDictionary<string, string> capacities = default;
            int clientConnectionEndpointPort = default;
            int httpGatewayEndpointPort = default;
            ClusterDurabilityLevel? durabilityLevel = default;
            ClusterEndpointRangeDescription applicationPorts = default;
            ClusterEndpointRangeDescription ephemeralPorts = default;
            bool isPrimary = default;
            int vmInstanceCount = default;
            int? reverseProxyEndpointPort = default;
            bool? isStateless = default;
            bool? multipleAvailabilityZones = default;
            int? httpGatewayTokenAuthEndpointPort = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("placementProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    placementProperties = dictionary;
                    continue;
                }
                if (property.NameEquals("capacities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    capacities = dictionary;
                    continue;
                }
                if (property.NameEquals("clientConnectionEndpointPort"u8))
                {
                    clientConnectionEndpointPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("httpGatewayEndpointPort"u8))
                {
                    httpGatewayEndpointPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("durabilityLevel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    durabilityLevel = new ClusterDurabilityLevel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("applicationPorts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    applicationPorts = ClusterEndpointRangeDescription.DeserializeClusterEndpointRangeDescription(property.Value, options);
                    continue;
                }
                if (property.NameEquals("ephemeralPorts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ephemeralPorts = ClusterEndpointRangeDescription.DeserializeClusterEndpointRangeDescription(property.Value, options);
                    continue;
                }
                if (property.NameEquals("isPrimary"u8))
                {
                    isPrimary = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("vmInstanceCount"u8))
                {
                    vmInstanceCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("reverseProxyEndpointPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reverseProxyEndpointPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("isStateless"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isStateless = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("multipleAvailabilityZones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    multipleAvailabilityZones = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("httpGatewayTokenAuthEndpointPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    httpGatewayTokenAuthEndpointPort = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClusterNodeTypeDescription(
                name,
                placementProperties ?? new ChangeTrackingDictionary<string, string>(),
                capacities ?? new ChangeTrackingDictionary<string, string>(),
                clientConnectionEndpointPort,
                httpGatewayEndpointPort,
                durabilityLevel,
                applicationPorts,
                ephemeralPorts,
                isPrimary,
                vmInstanceCount,
                reverseProxyEndpointPort,
                isStateless,
                multipleAvailabilityZones,
                httpGatewayTokenAuthEndpointPort,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ClusterNodeTypeDescription>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNodeTypeDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ClusterNodeTypeDescription)} does not support writing '{options.Format}' format.");
            }
        }

        ClusterNodeTypeDescription IPersistableModel<ClusterNodeTypeDescription>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClusterNodeTypeDescription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClusterNodeTypeDescription(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClusterNodeTypeDescription)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClusterNodeTypeDescription>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
