// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> Available cluster add-on features. </summary>
    public readonly partial struct ClusterAddOnFeature : IEquatable<ClusterAddOnFeature>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClusterAddOnFeature"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClusterAddOnFeature(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RepairManagerValue = "RepairManager";
        private const string DnsServiceValue = "DnsService";
        private const string BackupRestoreServiceValue = "BackupRestoreService";
        private const string ResourceMonitorServiceValue = "ResourceMonitorService";

        /// <summary> RepairManager. </summary>
        public static ClusterAddOnFeature RepairManager { get; } = new ClusterAddOnFeature(RepairManagerValue);
        /// <summary> DnsService. </summary>
        public static ClusterAddOnFeature DnsService { get; } = new ClusterAddOnFeature(DnsServiceValue);
        /// <summary> BackupRestoreService. </summary>
        public static ClusterAddOnFeature BackupRestoreService { get; } = new ClusterAddOnFeature(BackupRestoreServiceValue);
        /// <summary> ResourceMonitorService. </summary>
        public static ClusterAddOnFeature ResourceMonitorService { get; } = new ClusterAddOnFeature(ResourceMonitorServiceValue);
        /// <summary> Determines if two <see cref="ClusterAddOnFeature"/> values are the same. </summary>
        public static bool operator ==(ClusterAddOnFeature left, ClusterAddOnFeature right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClusterAddOnFeature"/> values are not the same. </summary>
        public static bool operator !=(ClusterAddOnFeature left, ClusterAddOnFeature right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClusterAddOnFeature"/>. </summary>
        public static implicit operator ClusterAddOnFeature(string value) => new ClusterAddOnFeature(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClusterAddOnFeature other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClusterAddOnFeature other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
