// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> The settings to enable AAD authentication on the cluster. </summary>
    public partial class ClusterAadSetting
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClusterAadSetting"/>. </summary>
        public ClusterAadSetting()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ClusterAadSetting"/>. </summary>
        /// <param name="tenantId"> Azure active directory tenant id. </param>
        /// <param name="clusterApplication"> Azure active directory cluster application id. </param>
        /// <param name="clientApplication"> Azure active directory client application id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClusterAadSetting(Guid? tenantId, string clusterApplication, string clientApplication, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TenantId = tenantId;
            ClusterApplication = clusterApplication;
            ClientApplication = clientApplication;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Azure active directory tenant id. </summary>
        public Guid? TenantId { get; set; }
        /// <summary> Azure active directory cluster application id. </summary>
        public string ClusterApplication { get; set; }
        /// <summary> Azure active directory client application id. </summary>
        public string ClientApplication { get; set; }
    }
}
