// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> The activation Mode of the service package. </summary>
    public readonly partial struct ArmUpgradeFailureAction : IEquatable<ArmUpgradeFailureAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ArmUpgradeFailureAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ArmUpgradeFailureAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RollbackValue = "Rollback";
        private const string ManualValue = "Manual";

        /// <summary> Indicates that a rollback of the upgrade will be performed by Service Fabric if the upgrade fails. </summary>
        public static ArmUpgradeFailureAction Rollback { get; } = new ArmUpgradeFailureAction(RollbackValue);
        /// <summary> Indicates that a manual repair will need to be performed by the administrator if the upgrade fails. Service Fabric will not proceed to the next upgrade domain automatically. </summary>
        public static ArmUpgradeFailureAction Manual { get; } = new ArmUpgradeFailureAction(ManualValue);
        /// <summary> Determines if two <see cref="ArmUpgradeFailureAction"/> values are the same. </summary>
        public static bool operator ==(ArmUpgradeFailureAction left, ArmUpgradeFailureAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ArmUpgradeFailureAction"/> values are not the same. </summary>
        public static bool operator !=(ArmUpgradeFailureAction left, ArmUpgradeFailureAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ArmUpgradeFailureAction"/>. </summary>
        public static implicit operator ArmUpgradeFailureAction(string value) => new ArmUpgradeFailureAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ArmUpgradeFailureAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ArmUpgradeFailureAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
