// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceFabric.Models
{
    /// <summary> The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. </summary>
    public readonly partial struct ApplicationRollingUpgradeMode : IEquatable<ApplicationRollingUpgradeMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApplicationRollingUpgradeMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApplicationRollingUpgradeMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string UnmonitoredAutoValue = "UnmonitoredAuto";
        private const string UnmonitoredManualValue = "UnmonitoredManual";
        private const string MonitoredValue = "Monitored";

        /// <summary> Indicates the upgrade mode is invalid. All Service Fabric enumerations have the invalid type. The value is zero. </summary>
        public static ApplicationRollingUpgradeMode Invalid { get; } = new ApplicationRollingUpgradeMode(InvalidValue);
        /// <summary> The upgrade will proceed automatically without performing any health monitoring. The value is 1. </summary>
        public static ApplicationRollingUpgradeMode UnmonitoredAuto { get; } = new ApplicationRollingUpgradeMode(UnmonitoredAutoValue);
        /// <summary> The upgrade will stop after completing each upgrade domain, giving the opportunity to manually monitor health before proceeding. The value is 2. </summary>
        public static ApplicationRollingUpgradeMode UnmonitoredManual { get; } = new ApplicationRollingUpgradeMode(UnmonitoredManualValue);
        /// <summary> The upgrade will stop after completing each upgrade domain and automatically monitor health before proceeding. The value is 3. </summary>
        public static ApplicationRollingUpgradeMode Monitored { get; } = new ApplicationRollingUpgradeMode(MonitoredValue);
        /// <summary> Determines if two <see cref="ApplicationRollingUpgradeMode"/> values are the same. </summary>
        public static bool operator ==(ApplicationRollingUpgradeMode left, ApplicationRollingUpgradeMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApplicationRollingUpgradeMode"/> values are not the same. </summary>
        public static bool operator !=(ApplicationRollingUpgradeMode left, ApplicationRollingUpgradeMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApplicationRollingUpgradeMode"/>. </summary>
        public static implicit operator ApplicationRollingUpgradeMode(string value) => new ApplicationRollingUpgradeMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApplicationRollingUpgradeMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApplicationRollingUpgradeMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
