// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ServiceFabric
{
    internal class ServiceFabricServiceOperationSource : IOperationSource<ServiceFabricServiceResource>
    {
        private readonly ArmClient _client;

        internal ServiceFabricServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceFabricServiceResource IOperationSource<ServiceFabricServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ServiceFabricServiceData.DeserializeServiceFabricServiceData(document.RootElement);
            return new ServiceFabricServiceResource(_client, data);
        }

        async ValueTask<ServiceFabricServiceResource> IOperationSource<ServiceFabricServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ServiceFabricServiceData.DeserializeServiceFabricServiceData(document.RootElement);
            return new ServiceFabricServiceResource(_client, data);
        }
    }
}
